/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp;

import android.util.Log;
import com.arellomobile.mvp.MvpFacade;
import com.arellomobile.mvp.MvpPresenter;
import com.arellomobile.mvp.ParamsHolder;
import com.arellomobile.mvp.PresenterBinder;
import com.arellomobile.mvp.PresenterFactory;
import com.arellomobile.mvp.PresenterStore;
import com.arellomobile.mvp.presenter.PresenterField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MvpProcessor {
    private static final String TAG = "MvpProcessor";
    public static final String PRESENTER_BINDER_SUFFIX = "$$PresentersBinder";
    public static final String VIEW_STATE_SUFFIX = "$$State";
    public static final String FACTORY_PARAMS_HOLDER_SUFFIX = "$$ParamsHolder";
    public static final String PRESENTER_BINDER_INNER_SUFFIX = "Binder";
    public static final String VIEW_STATE_CLASS_NAME_PROVIDER_SUFFIX = "$$ViewStateClassNameProvider";

    private <Delegated> PresenterBinder<Delegated> getPresenterBinder(Delegated delegated) {
        PresenterBinder<?> binder;
        try {
            binder = this.findPresenterBinderForClass(delegated.getClass());
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("can not instantiate binder for " + delegated.getClass().getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("have no access to binder for " + delegated.getClass().getName(), e);
        }
        return binder;
    }

    private <Delegated> PresenterBinder<? super Delegated> findPresenterBinderForClass(Class<Delegated> clazz) throws IllegalAccessException, InstantiationException {
        PresenterBinder<Delegated> presenterBinder;
        String clsName = clazz.getName();
        String className = clsName + PRESENTER_BINDER_SUFFIX;
        try {
            Class<?> presenterBinderClass = Class.forName(className);
            presenterBinder = (PresenterBinder<Delegated>)presenterBinderClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            Log.d((String)TAG, (String)("Not found " + className + ". Trying superclass " + clazz.getSuperclass().getName()));
            if (clazz.getSuperclass() == Object.class) {
                return null;
            }
            presenterBinder = this.findPresenterBinderForClass(clazz.getSuperclass());
        }
        return presenterBinder;
    }

    private <Delegated> MvpPresenter<? super Delegated> getMvpPresenter(PresenterField<? super Delegated> presenterField, Delegated delegated, String delegateTag) {
        Object params;
        PresenterFactory<?, ?> presenterFactory;
        String tag;
        Class<MvpPresenter<? super Delegated>> presenterClass = presenterField.getPresenterClass();
        Class<PresenterFactory<?, ?>> presenterFactoryClass = presenterField.getFactory();
        ParamsHolder<Delegated> holder = MvpFacade.getInstance().getPresenterFactoryStore().getParamsHolder(presenterField.getParamsHolderClass());
        PresenterStore presenterStore = MvpFacade.getInstance().getPresenterStore();
        MvpPresenter<Delegated> presenter = presenterStore.get(tag = (presenterFactory = MvpFacade.getInstance().getPresenterFactoryStore().getPresenterFactory(presenterFactoryClass)).createTag(presenterClass, params = holder.getParams(presenterField, delegated, delegateTag)), presenterClass);
        if (presenter != null) {
            return presenter;
        }
        presenter = presenterFactory.createPresenter(presenterClass, params);
        presenter.setPresenterType(presenterField.getPresenterType());
        presenter.setTag(tag);
        presenterStore.add(tag, presenter);
        return presenter;
    }

    <Delegated> List<MvpPresenter<? super Delegated>> getMvpPresenters(Delegated delegated, String delegateTag) {
        PresenterBinder<Delegated> binder = MvpFacade.getInstance().getMvpProcessor().getPresenterBinder(delegated);
        if (binder == null) {
            return Collections.emptyList();
        }
        binder.setTarget(delegated);
        List<PresenterField<Delegated>> presenterFields = binder.getPresenterFields();
        ArrayList<MvpPresenter<Delegated>> presenters = new ArrayList<MvpPresenter<Delegated>>(presenterFields.size());
        for (PresenterField<Delegated> presenterField : presenterFields) {
            MvpPresenter<Delegated> presenter = this.getMvpPresenter(presenterField, delegated, delegateTag);
            if (presenter == null) continue;
            presenters.add(presenter);
            presenterField.setValue(presenter);
        }
        return presenters;
    }
}

