/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp;

import android.util.Log;
import com.arellomobile.mvp.MvpFacade;
import com.arellomobile.mvp.MvpPresenter;
import com.arellomobile.mvp.ParamsHolder;
import com.arellomobile.mvp.PresenterBinder;
import com.arellomobile.mvp.PresenterFactory;
import com.arellomobile.mvp.PresenterStore;
import com.arellomobile.mvp.presenter.PresenterField;
import com.arellomobile.mvp.presenter.PresenterType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MvpProcessor {
    private static final String TAG = "MvpProcessor";
    public static final String PRESENTER_BINDER_SUFFIX = "$$PresentersBinder";
    public static final String VIEW_STATE_SUFFIX = "$$State";
    public static final String FACTORY_PARAMS_HOLDER_SUFFIX = "$$ParamsHolder";
    public static final String PRESENTER_BINDER_INNER_SUFFIX = "Binder";
    public static final String VIEW_STATE_CLASS_NAME_PROVIDER_SUFFIX = "$$ViewStateClassNameProvider";

    private <Delegated> PresenterBinder<? super Delegated> getPresenterBinder(Class<? super Delegated> delegated) {
        PresenterBinder<? super Delegated> binder;
        try {
            binder = this.findPresenterBinderForClass(delegated);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("can not instantiate binder for " + delegated.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("have no access to binder for " + delegated.getName(), e);
        }
        return binder;
    }

    private <Delegated> PresenterBinder<? super Delegated> findPresenterBinderForClass(Class<Delegated> clazz) throws IllegalAccessException, InstantiationException {
        PresenterBinder presenterBinder;
        String clsName = clazz.getName();
        String className = clsName + PRESENTER_BINDER_SUFFIX;
        try {
            Class<?> presenterBinderClass = Class.forName(className);
            presenterBinder = (PresenterBinder)presenterBinderClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            Log.d((String)TAG, (String)("Not found " + className + ". Trying superclass " + clazz.getSuperclass().getName()));
            return null;
        }
        return presenterBinder;
    }

    private <Delegated> MvpPresenter<? super Delegated> getMvpPresenter(PresenterField<? super Delegated> presenterField, Delegated delegated, String delegateTag) {
        Class<MvpPresenter<? super Delegated>> presenterClass = presenterField.getPresenterClass();
        Class<PresenterFactory<?, ?>> presenterFactoryClass = presenterField.getFactory();
        ParamsHolder<Delegated> holder = MvpFacade.getInstance().getPresenterFactoryStore().getParamsHolder(presenterField.getParamsHolderClass());
        PresenterStore presenterStore = MvpFacade.getInstance().getPresenterStore();
        PresenterFactory<?, ?> presenterFactory = MvpFacade.getInstance().getPresenterFactoryStore().getPresenterFactory(presenterFactoryClass);
        Object params = holder.getParams(presenterField, delegated, delegateTag);
        String tag = presenterFactory.createTag(presenterClass, params);
        PresenterType type = presenterField.getPresenterType();
        MvpPresenter<Delegated> presenter = presenterStore.get(type, tag, presenterClass);
        if (presenter != null) {
            return presenter;
        }
        presenter = presenterFactory.createPresenter(presenterField.getDefaultInstance(), presenterClass, params);
        presenter.setPresenterType(type);
        presenter.setTag(tag);
        presenterStore.add(type, tag, presenter);
        return presenter;
    }

    <Delegated> List<MvpPresenter<? super Delegated>> getMvpPresenters(Delegated delegated, String delegateTag) {
        ArrayList presenterBinders = new ArrayList();
        for (Class<?> aClass = delegated.getClass(); aClass != Object.class; aClass = aClass.getSuperclass()) {
            PresenterBinder<?> presenterBinder = MvpFacade.getInstance().getMvpProcessor().getPresenterBinder(aClass);
            if (presenterBinder == null) continue;
            presenterBinder.setTarget(delegated);
            presenterBinders.add(presenterBinder);
        }
        if (presenterBinders.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MvpPresenter<Delegated>> presenters = new ArrayList<MvpPresenter<Delegated>>();
        for (PresenterBinder presenterBinder : presenterBinders) {
            List presenterFields = presenterBinder.getPresenterFields();
            for (PresenterField presenterField : presenterFields) {
                MvpPresenter presenter = this.getMvpPresenter(presenterField, delegated, delegateTag);
                if (presenter == null) continue;
                presenters.add(presenter);
                presenterField.setValue(presenter);
            }
        }
        return presenters;
    }
}

