/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class WeakValueHashMap<K, V>
extends AbstractMap<K, V> {
    private HashMap<K, WeakValue<V>> references;
    private ReferenceQueue<V> gcQueue;

    public WeakValueHashMap(int capacity) {
        this.references = new HashMap(capacity);
        this.gcQueue = new ReferenceQueue();
    }

    public WeakValueHashMap() {
        this(1);
    }

    public WeakValueHashMap(Map<? extends K, ? extends V> map) {
        this(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        WeakValue valueRef = new WeakValue(key, value, this.gcQueue);
        return (V)this.getReferenceValue(this.references.put(key, valueRef));
    }

    @Override
    public V get(Object key) {
        this.processQueue();
        return this.getReferenceValue(this.references.get(key));
    }

    @Override
    public V remove(Object key) {
        return this.getReferenceValue(this.references.remove(key));
    }

    @Override
    public void clear() {
        this.references.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        this.processQueue();
        return this.references.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.processQueue();
        for (Map.Entry<K, WeakValue<V>> entry : this.references.entrySet()) {
            if (value != this.getReferenceValue(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        this.processQueue();
        return this.references.keySet();
    }

    @Override
    public int size() {
        this.processQueue();
        return this.references.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.processQueue();
        LinkedHashSet<Map.Entry<K, V>> entries = new LinkedHashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, WeakValue<V>> entry : this.references.entrySet()) {
            entries.add(new AbstractMap.SimpleEntry<K, V>(entry.getKey(), this.getReferenceValue(entry.getValue())));
        }
        return entries;
    }

    @Override
    public Collection<V> values() {
        this.processQueue();
        ArrayList<V> values = new ArrayList<V>();
        for (WeakValue<V> valueRef : this.references.values()) {
            values.add(this.getReferenceValue(valueRef));
        }
        return values;
    }

    private V getReferenceValue(WeakValue<V> valueRef) {
        return valueRef == null ? null : (V)valueRef.get();
    }

    private void processQueue() {
        WeakValue valueRef;
        while ((valueRef = (WeakValue)this.gcQueue.poll()) != null) {
            this.references.remove(valueRef.getKey());
        }
    }

    private class WeakValue<T>
    extends WeakReference<T> {
        private final K key;

        private WeakValue(K key, T value, ReferenceQueue<T> queue) {
            super(value, queue);
            this.key = key;
        }

        private K getKey() {
            return this.key;
        }
    }
}

