/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp.viewstate;

import com.arellomobile.mvp.MvpView;
import com.arellomobile.mvp.Pair;
import com.arellomobile.mvp.viewstate.ViewCommand;
import com.arellomobile.mvp.viewstate.strategy.StateStrategy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ViewCommands<View extends MvpView> {
    private List<Pair<ViewCommand<View>, Object>> mStatesPairList = new ArrayList<Pair<ViewCommand<View>, Object>>();
    private Map<Class<? extends StateStrategy>, StateStrategy> mStrategies = new HashMap<Class<? extends StateStrategy>, StateStrategy>();

    public void beforeApply(ViewCommand<View> viewCommand) {
        this.beforeApply(viewCommand, null);
    }

    public void beforeApply(ViewCommand<View> viewCommand, Object params) {
        StateStrategy stateStrategy = this.getStateStrategy(viewCommand);
        stateStrategy.beforeApply(this.mStatesPairList, Pair.create(viewCommand, params));
    }

    public void afterApply(ViewCommand<View> viewCommand) {
        this.afterApply(viewCommand, null);
    }

    public void afterApply(ViewCommand<View> viewCommand, Object params) {
        StateStrategy stateStrategy = this.getStateStrategy(viewCommand);
        stateStrategy.afterApply(this.mStatesPairList, Pair.create(viewCommand, params));
    }

    private StateStrategy getStateStrategy(ViewCommand<View> viewCommand) {
        StateStrategy stateStrategy = this.mStrategies.get(viewCommand.getStrategyType());
        if (stateStrategy == null) {
            try {
                stateStrategy = viewCommand.getStrategyType().newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Unable to create state strategy: " + viewCommand.toString());
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Unable to create state strategy: " + viewCommand.toString());
            }
            this.mStrategies.put(viewCommand.getStrategyType(), stateStrategy);
        }
        return stateStrategy;
    }

    public boolean isEmpty() {
        return this.mStatesPairList.isEmpty();
    }

    public void reapply(View view) {
        ArrayList<Pair<ViewCommand<View>, Object>> statePairsList = new ArrayList<Pair<ViewCommand<View>, Object>>(this.mStatesPairList);
        for (Pair<ViewCommand<View>, Object> entry : statePairsList) {
            ((ViewCommand)entry.first).apply(view, entry.second);
            this.afterApply((ViewCommand)entry.first, entry.second);
        }
    }
}

