/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp;

import com.arellomobile.mvp.MvpPresenter;
import com.arellomobile.mvp.WeakValueHashMap;
import com.arellomobile.mvp.presenter.PresenterType;
import java.util.HashMap;
import java.util.Map;

public class PresenterStore {
    private Map<Class<? extends MvpPresenter>, Map<String, MvpPresenter>> mGlobalPresenters = new HashMap<Class<? extends MvpPresenter>, Map<String, MvpPresenter>>();
    private Map<Class<? extends MvpPresenter>, Map<String, MvpPresenter>> mWeakPresenters = new WeakValueHashMap<Class<? extends MvpPresenter>, Map<String, MvpPresenter>>();

    public <T extends MvpPresenter> void add(PresenterType type, String tag, T instance) {
        Map<String, MvpPresenter> mvpPresenterMap;
        Map<Class<? extends MvpPresenter>, Map<String, MvpPresenter>> presenters = this.getPresenters(type);
        if (presenters.containsKey(instance.getClass())) {
            mvpPresenterMap = presenters.get(instance.getClass());
        } else {
            mvpPresenterMap = this.createPresentersStore(type);
            presenters.put(instance.getClass(), mvpPresenterMap);
        }
        if (mvpPresenterMap.containsKey(tag)) {
            throw new IllegalStateException("mvp multiple presenters map already contains tag");
        }
        mvpPresenterMap.put(tag, instance);
    }

    public MvpPresenter get(PresenterType type, String tag, Class<? extends MvpPresenter> clazz) {
        Map<String, MvpPresenter> tagMvpPresenterMap = this.getPresenters(type).get(clazz);
        if (tagMvpPresenterMap == null) {
            return null;
        }
        return tagMvpPresenterMap.get(tag);
    }

    public MvpPresenter remove(PresenterType type, String tag, Class<? extends MvpPresenter> clazz) {
        Map<String, MvpPresenter> tagMvpPresenterMap = this.getPresenters(type).get(clazz);
        if (tagMvpPresenterMap == null) {
            return null;
        }
        return tagMvpPresenterMap.remove(tag);
    }

    private Map<Class<? extends MvpPresenter>, Map<String, MvpPresenter>> getPresenters(PresenterType type) {
        if (type == PresenterType.WEAK) {
            return this.mWeakPresenters;
        }
        return this.mGlobalPresenters;
    }

    private Map<String, MvpPresenter> createPresentersStore(PresenterType type) {
        if (type == PresenterType.WEAK) {
            return new WeakValueHashMap<String, MvpPresenter>();
        }
        return new HashMap<String, MvpPresenter>();
    }
}

