/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp;

import com.arellomobile.mvp.MvpView;
import com.arellomobile.mvp.ViewStateClassNameProvider;
import com.arellomobile.mvp.presenter.PresenterType;
import com.arellomobile.mvp.viewstate.MvpViewState;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;

public abstract class MvpPresenter<View extends MvpView> {
    private boolean mFirstLaunch = true;
    private String mTag;
    private PresenterType mPresenterType;
    private Set<View> mViews;
    private View mViewStateAsView;
    private MvpViewState<View> mViewState;

    public MvpPresenter() {
        Binder.bind(this);
        this.mViews = Collections.newSetFromMap(new WeakHashMap());
    }

    public void attachView(View view) {
        if (this.mViewState != null) {
            this.mViewState.attachView(view);
        } else {
            this.mViews.add(view);
        }
        if (this.mFirstLaunch) {
            this.mFirstLaunch = false;
            this.onFirstViewAttach();
        }
    }

    protected void onFirstViewAttach() {
    }

    public void detachView(View view) {
        if (this.mViewState != null) {
            this.mViewState.detachView(view);
        } else {
            this.mViews.remove(view);
        }
    }

    public Set<View> getAttachedViews() {
        if (this.mViewState != null) {
            return this.mViewState.getViews();
        }
        return this.mViews;
    }

    public View getViewState() {
        return this.mViewStateAsView;
    }

    public boolean isInRestoreState(View view) {
        if (this.mViewState != null) {
            return this.mViewState.isInRestoreState(view);
        }
        return false;
    }

    public void setViewState(MvpViewState<View> viewState) {
        this.mViewStateAsView = (MvpView)((Object)viewState);
        this.mViewState = viewState;
    }

    PresenterType getPresenterType() {
        return this.mPresenterType;
    }

    void setPresenterType(PresenterType presenterType) {
        this.mPresenterType = presenterType;
    }

    String getTag() {
        return this.mTag;
    }

    void setTag(String tag) {
        this.mTag = tag;
    }

    public void onDestroy() {
    }

    private static class Binder {
        private Binder() {
        }

        static void bind(MvpPresenter presenter) {
            Object viewState;
            ViewStateClassNameProvider viewStateClassNameProvider;
            String viewStateClassNameProviderClassName = presenter.getClass().getName() + "$$ViewStateClassNameProvider";
            try {
                viewStateClassNameProvider = (ViewStateClassNameProvider)Class.forName(viewStateClassNameProviderClassName).newInstance();
            }
            catch (ClassNotFoundException e) {
                return;
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Unable to instantiate " + viewStateClassNameProviderClassName + ": " + "make sure class name exists, " + "is public, and " + "has an empty constructor that is public", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to instantiate " + viewStateClassNameProviderClassName + ": " + "make sure class name exists, " + "is public, and " + "has an empty constructor that is public", e);
            }
            String viewStateClassName = viewStateClassNameProvider.getViewStateClassName();
            try {
                viewState = Class.forName(viewStateClassName).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate " + viewStateClassName + ": " + "make sure class name exists, " + "is public, and " + "has an empty constructor that is public", e);
            }
            presenter.mViewStateAsView = (MvpView)viewState;
            presenter.mViewState = (MvpViewState)viewState;
        }
    }
}

