/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp.viewstate;

import com.arellomobile.mvp.MvpView;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;

public abstract class MvpViewState<View extends MvpView> {
    protected Set<View> mViews = Collections.newSetFromMap(new WeakHashMap());
    protected Set<View> mInRestoreState = Collections.newSetFromMap(new WeakHashMap());

    protected abstract void restoreState(View var1);

    public void attachView(View view) {
        if (view == null) {
            throw new IllegalArgumentException("Mvp view must be not null");
        }
        boolean isViewAdded = this.mViews.add(view);
        if (!isViewAdded) {
            return;
        }
        this.mInRestoreState.add(view);
        this.restoreState(view);
        this.mInRestoreState.remove(view);
    }

    public void detachView(View view) {
        this.mViews.remove(view);
        this.mInRestoreState.remove(view);
    }

    public Set<View> getViews() {
        return this.mViews;
    }

    public boolean isInRestoreState(View view) {
        return this.mInRestoreState.contains(view);
    }
}

