/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp;

import android.os.Bundle;
import com.arellomobile.mvp.MvpFacade;
import com.arellomobile.mvp.MvpPresenter;
import com.arellomobile.mvp.MvpView;
import com.arellomobile.mvp.PresenterStore;
import com.arellomobile.mvp.presenter.PresenterType;
import java.util.ArrayList;
import java.util.List;

public class MvpDelegate<Delegated> {
    private static final String KEY_TAGS = "com.arellomobile.mvp.MvpDelegate.KEY_TAGS";
    private String mKeyTags = "com.arellomobile.mvp.MvpDelegate.KEY_TAGS";
    private String mDelegateTag;
    private final Delegated mDelegated;
    private boolean mIsAttached;
    private MvpDelegate mParentDelegate;
    private List<MvpPresenter<? super Delegated>> mPresenters;
    private List<MvpDelegate> mChildDelegates;
    private Bundle mBundle;

    public MvpDelegate(Delegated delegated) {
        this.mDelegated = delegated;
        this.mChildDelegates = new ArrayList<MvpDelegate>();
    }

    public void setParentDelegate(MvpDelegate delegate, String childId) {
        if (this.mBundle != null) {
            throw new IllegalStateException("You should call setParentDelegate() before first onCreate()");
        }
        if (this.mChildDelegates != null && this.mChildDelegates.size() > 0) {
            throw new IllegalStateException("You could not set parent delegate when it already has child presenters");
        }
        this.mParentDelegate = delegate;
        this.mKeyTags = this.mParentDelegate.mKeyTags + "$" + childId;
        delegate.addChildDelegate(this);
    }

    private void addChildDelegate(MvpDelegate delegate) {
        this.mChildDelegates.add(delegate);
    }

    public void onCreate() {
        Bundle bundle = new Bundle();
        if (this.mParentDelegate != null) {
            bundle = this.mParentDelegate.mBundle;
        }
        this.onCreate(bundle);
    }

    public void onCreate(Bundle bundle) {
        this.mIsAttached = false;
        this.mBundle = bundle;
        this.mDelegateTag = bundle == null || !this.mBundle.containsKey(this.mKeyTags) ? this.generateTag() : bundle.getString(this.mKeyTags);
        this.mPresenters = MvpFacade.getInstance().getMvpProcessor().getMvpPresenters(this.mDelegated, this.mDelegateTag);
        for (MvpDelegate childDelegate : this.mChildDelegates) {
            childDelegate.onCreate(bundle);
        }
    }

    public void onAttach() {
        for (MvpPresenter<Delegated> presenter : this.mPresenters) {
            if (this.mIsAttached && presenter.getAttachedViews().contains(this.mDelegated)) continue;
            presenter.attachView((MvpView)this.mDelegated);
        }
        for (MvpDelegate childDelegate : this.mChildDelegates) {
            childDelegate.onAttach();
        }
        this.mIsAttached = true;
    }

    public void onDetach() {
        for (MvpPresenter<Delegated> presenter : this.mPresenters) {
            presenter.detachView((MvpView)this.mDelegated);
        }
        this.mIsAttached = false;
        for (MvpDelegate childDelegate : this.mChildDelegates) {
            childDelegate.onDetach();
        }
    }

    public void onDestroy() {
        PresenterStore presenterStore = MvpFacade.getInstance().getPresenterStore();
        for (MvpPresenter<Delegated> presenter : this.mPresenters) {
            if (presenter.getPresenterType() != PresenterType.LOCAL) continue;
            presenter.onDestroy();
            presenterStore.remove(PresenterType.LOCAL, presenter.getTag(), presenter.getPresenterClass());
        }
        for (MvpDelegate childDelegate : this.mChildDelegates) {
            childDelegate.onDestroy();
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putString(this.mKeyTags, this.mDelegateTag);
        for (MvpDelegate childDelegate : this.mChildDelegates) {
            childDelegate.onSaveInstanceState(outState);
        }
    }

    private String generateTag() {
        return this.mDelegated.getClass().getName() + "$" + this.getClass().getSimpleName() + this.toString().replace(this.getClass().getName(), "");
    }
}

