/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp.viewstate;

import com.arellomobile.mvp.MvpView;
import com.arellomobile.mvp.viewstate.ViewCommand;
import com.arellomobile.mvp.viewstate.strategy.StateStrategy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ViewCommands<View extends MvpView> {
    private List<ViewCommand<View>> mState = new ArrayList<ViewCommand<View>>();
    private Map<Class<? extends StateStrategy>, StateStrategy> mStrategies = new HashMap<Class<? extends StateStrategy>, StateStrategy>();

    public void beforeApply(ViewCommand<View> viewCommand) {
        StateStrategy stateStrategy = this.getStateStrategy(viewCommand);
        stateStrategy.beforeApply(this.mState, viewCommand);
    }

    public void afterApply(ViewCommand<View> viewCommand) {
        StateStrategy stateStrategy = this.getStateStrategy(viewCommand);
        stateStrategy.afterApply(this.mState, viewCommand);
    }

    private StateStrategy getStateStrategy(ViewCommand<View> viewCommand) {
        StateStrategy stateStrategy = this.mStrategies.get(viewCommand.getStrategyType());
        if (stateStrategy == null) {
            try {
                stateStrategy = viewCommand.getStrategyType().newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Unable to create state strategy: " + viewCommand.toString());
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Unable to create state strategy: " + viewCommand.toString());
            }
            this.mStrategies.put(viewCommand.getStrategyType(), stateStrategy);
        }
        return stateStrategy;
    }

    public boolean isEmpty() {
        return this.mState.isEmpty();
    }

    public void reapply(View view) {
        ArrayList<ViewCommand<View>> commands = new ArrayList<ViewCommand<View>>(this.mState);
        for (ViewCommand<View> command : commands) {
            command.apply(view);
            this.afterApply(command);
        }
    }
}

