/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp;

import com.arellomobile.mvp.MvpPresenter;
import com.arellomobile.mvp.presenter.PresenterType;
import java.util.HashMap;
import java.util.Map;

public class PresenterStore {
    private Map<Key, MvpPresenter> mPresenters = new HashMap<Key, MvpPresenter>();

    public <T extends MvpPresenter> void add(PresenterType type, String tag, Class<? extends MvpPresenter> clazz, T instance) {
        Key key = new Key(type, clazz, tag);
        this.mPresenters.put(key, instance);
    }

    public MvpPresenter get(PresenterType type, String tag, Class<? extends MvpPresenter> clazz) {
        Key key = new Key(type, clazz, tag);
        return this.mPresenters.get(key);
    }

    public MvpPresenter remove(PresenterType type, String tag, Class<? extends MvpPresenter> clazz) {
        Key key = new Key(type, clazz, tag);
        return this.mPresenters.remove(key);
    }

    private static class Key {
        PresenterType mPresenterType;
        Class<? extends MvpPresenter> mPresenterClass;
        String mPresenterTag;

        Key(PresenterType presenterType, Class<? extends MvpPresenter> presenterClass, String presenterTag) {
            this.mPresenterType = presenterType;
            this.mPresenterClass = presenterClass;
            this.mPresenterTag = presenterTag;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.mPresenterType != key.mPresenterType) {
                return false;
            }
            if (!this.mPresenterClass.equals(key.mPresenterClass)) {
                return false;
            }
            return this.mPresenterTag.equals(key.mPresenterTag);
        }

        public int hashCode() {
            int result = this.mPresenterType.hashCode();
            result = 31 * result + this.mPresenterClass.hashCode();
            result = 31 * result + this.mPresenterTag.hashCode();
            return result;
        }
    }
}

