/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp;

import com.arellomobile.mvp.MvpPresenter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PresentersCounter {
    private Map<MvpPresenter<?>, Set<String>> mConnections = new HashMap();

    public void injectPresenter(MvpPresenter<?> presenter, String delegateTag) {
        Set<String> delegateTags = this.mConnections.get(presenter);
        if (delegateTags == null) {
            delegateTags = new HashSet<String>();
            this.mConnections.put(presenter, delegateTags);
        }
        delegateTags.add(delegateTag);
    }

    public boolean rejectPresenter(MvpPresenter<?> presenter, String delegateTag) {
        Set<String> delegateTags = this.mConnections.get(presenter);
        if (delegateTags == null) {
            this.mConnections.remove(presenter);
            return true;
        }
        delegateTags.remove(delegateTag);
        boolean noTags = delegateTags.isEmpty();
        if (noTags) {
            this.mConnections.remove(presenter);
        }
        return noTags;
    }

    public boolean isInjected(MvpPresenter<?> presenter) {
        Set<String> mDelegateTags = this.mConnections.get(presenter);
        return mDelegateTags != null && !mDelegateTags.isEmpty();
    }
}

