/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp;

import com.arellomobile.mvp.MoxyReflector;
import com.arellomobile.mvp.MvpFacade;
import com.arellomobile.mvp.MvpPresenter;
import com.arellomobile.mvp.PresenterBinder;
import com.arellomobile.mvp.PresenterStore;
import com.arellomobile.mvp.PresentersCounter;
import com.arellomobile.mvp.presenter.PresenterField;
import com.arellomobile.mvp.presenter.PresenterType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MvpProcessor {
    public static final String PRESENTER_BINDER_SUFFIX = "$$PresentersBinder";
    public static final String PRESENTER_BINDER_INNER_SUFFIX = "Binder";
    public static final String VIEW_STATE_SUFFIX = "$$State";
    public static final String VIEW_STATE_PROVIDER_SUFFIX = "$$ViewStateProvider";
    private static Boolean hasMoxyReflector = null;

    private <Delegated> MvpPresenter<? super Delegated> getMvpPresenter(Delegated target, PresenterField<Delegated> presenterField, String delegateTag) {
        PresenterType type;
        String tag;
        Class<MvpPresenter<?>> presenterClass = presenterField.getPresenterClass();
        PresenterStore presenterStore = MvpFacade.getInstance().getPresenterStore();
        MvpPresenter<?> presenter = presenterStore.get(tag = (type = presenterField.getPresenterType()) == PresenterType.LOCAL ? delegateTag + "$" + presenterField.getTag(target) : presenterField.getTag(target));
        if (presenter != null) {
            return presenter;
        }
        presenter = presenterField.providePresenter(target);
        if (presenter == null) {
            return null;
        }
        presenter.setPresenterType(type);
        presenter.setTag(tag);
        presenter.setPresenterClass(presenterClass);
        presenterStore.add(tag, presenter);
        return presenter;
    }

    <Delegated> List<MvpPresenter<? super Delegated>> getMvpPresenters(Delegated delegated, String delegateTag) {
        if (!MvpProcessor.hasMoxyReflector()) {
            return Collections.emptyList();
        }
        List presenterBinders = null;
        for (Class<?> aClass = delegated.getClass(); aClass != Object.class && presenterBinders == null; aClass = aClass.getSuperclass()) {
            presenterBinders = MoxyReflector.getPresenterBinders(aClass);
        }
        if (presenterBinders == null || presenterBinders.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MvpPresenter<Delegated>> presenters = new ArrayList<MvpPresenter<Delegated>>();
        PresentersCounter presentersCounter = MvpFacade.getInstance().getPresentersCounter();
        for (Object presenterBinderObject : presenterBinders) {
            PresenterBinder presenterBinder = (PresenterBinder)presenterBinderObject;
            List presenterFields = presenterBinder.getPresenterFields();
            for (PresenterField<Delegated> presenterField : presenterFields) {
                MvpPresenter<Delegated> presenter = this.getMvpPresenter(delegated, presenterField, delegateTag);
                if (presenter == null) continue;
                presentersCounter.injectPresenter(presenter, delegateTag);
                presenters.add(presenter);
                presenterField.bind(delegated, presenter);
            }
        }
        return presenters;
    }

    private static boolean hasMoxyReflector() {
        if (hasMoxyReflector != null) {
            return hasMoxyReflector;
        }
        try {
            new MoxyReflector();
            hasMoxyReflector = true;
        }
        catch (NoClassDefFoundError error) {
            hasMoxyReflector = false;
        }
        return hasMoxyReflector;
    }
}

