/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.common.beans;

import com.arextest.common.filter.ContentFilter;
import com.arextest.common.interceptor.MetricInterceptor;
import com.arextest.common.metrics.MetricListener;
import java.util.List;
import javax.servlet.Filter;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class ContentInterceptorConfiguration
implements WebMvcConfigurer {
    private final MetricInterceptor metricInterceptor;
    private final List<MetricListener> metricListeners;
    @Value(value="${arex.common.record.payload.with.metric:false}")
    private boolean recordPayloadWithMetric;

    public ContentInterceptorConfiguration(MetricInterceptor metricInterceptor, List<MetricListener> metricListeners) {
        this.metricInterceptor = metricInterceptor;
        this.metricListeners = metricListeners;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        if (CollectionUtils.isEmpty(this.metricListeners)) {
            return;
        }
        registry.addInterceptor((HandlerInterceptor)this.metricInterceptor);
    }

    @Bean
    public FilterRegistrationBean<ContentFilter> contentCachingFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new ContentFilter(this.metricListeners, this.recordPayloadWithMetric));
        registrationBean.setOrder(Integer.MIN_VALUE);
        registrationBean.addUrlPatterns(new String[]{"/*"});
        return registrationBean;
    }
}

