/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.common.cache;

import com.arextest.common.cache.CacheProvider;
import com.arextest.common.cache.LockWrapper;
import com.arextest.common.cache.RedissonLock;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.redisson.api.RedissonClient;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.util.Pool;

public class AbstractRedisCacheProvider
implements CacheProvider {
    private static final String STATUS_CODE = "OK";
    RedissonClient redissonClient;
    Pool<Jedis> jedisPool;

    public static byte[] getRequestId() {
        return UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public boolean put(byte[] key, long expiredSeconds, byte[] value) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            boolean bl = this.statusCode2Boolean(jedis.setex(key, (int)expiredSeconds, value));
            return bl;
        }
    }

    @Override
    public boolean put(byte[] key, byte[] value) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            boolean bl = this.statusCode2Boolean(jedis.set(key, value));
            return bl;
        }
    }

    @Override
    public boolean putIfAbsent(byte[] key, long expiredSeconds, byte[] value) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            boolean nxResult = this.integer2Boolean(jedis.setnx(key, value));
            if (nxResult) {
                this.expire(key, expiredSeconds);
            }
            boolean bl = nxResult;
            return bl;
        }
    }

    @Override
    public byte[] get(byte[] key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            byte[] byArray = jedis.get(key);
            return byArray;
        }
    }

    @Override
    public long incrValue(byte[] key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            long l = jedis.incr(key);
            return l;
        }
    }

    @Override
    public long incrValueBy(byte[] key, long value) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            long l = jedis.incrBy(key, value);
            return l;
        }
    }

    @Override
    public long decrValue(byte[] key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            long l = jedis.decr(key);
            return l;
        }
    }

    @Override
    public long decrValueBy(byte[] key, long value) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            long l = jedis.decrBy(key, value);
            return l;
        }
    }

    @Override
    public boolean remove(byte[] key) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            boolean bl = this.integer2Boolean(jedis.del(key));
            return bl;
        }
    }

    @Override
    public boolean expire(byte[] key, long seconds) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            boolean bl = this.integer2Boolean(jedis.expire(key, (int)seconds));
            return bl;
        }
    }

    @Override
    public LockWrapper getLock(String namespaceId) {
        return new RedissonLock(this.redissonClient.getLock(namespaceId));
    }

    @Override
    public RedissonClient getRedissionClient() {
        return this.redissonClient;
    }

    private boolean statusCode2Boolean(String statusCode) {
        return STATUS_CODE.equals(statusCode);
    }

    private boolean integer2Boolean(long l) {
        return l > 0L;
    }
}

