/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.common.cache;

import com.arextest.common.cache.AbstractRedisCacheProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.ReplicatedServersConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class DefaultRedisCacheProvider
extends AbstractRedisCacheProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRedisCacheProvider.class);
    private static final String USERNAME_AND_PASSWORD_REGEX = "redis://(.*?)@(.*?)";
    private static final String DATABASE_REGEX = "redis://(.*?)/(.*?)";

    public DefaultRedisCacheProvider() {
        this.jedisPool = new JedisPool();
    }

    public DefaultRedisCacheProvider(String redisHost) {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(1024);
        jedisPoolConfig.setMaxIdle(100);
        jedisPoolConfig.setMaxWaitMillis(100L);
        jedisPoolConfig.setTestOnBorrow(false);
        jedisPoolConfig.setTestOnReturn(true);
        try {
            this.jedisPool = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, new URI(redisHost));
            this.redissonClient = this.createRedissonClientByAnalyze(redisHost);
        }
        catch (URISyntaxException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private RedissonClient createRedissonClientByAnalyze(String redisUri) {
        Integer dataBase;
        Config config = new Config();
        ReplicatedServersConfig replicatedServersConfig = config.useReplicatedServers().setScanInterval(2000);
        List<String> redisHostAndPort = this.getRedisHostAndPort(redisUri);
        replicatedServersConfig.addNodeAddress(redisHostAndPort.toArray(new String[0]));
        Pair<String, String> userNameAndPassword = this.getUserNameAndPassword(redisUri);
        String user = (String)userNameAndPassword.getKey();
        String password = (String)userNameAndPassword.getValue();
        if (StringUtils.isNotEmpty((CharSequence)user)) {
            replicatedServersConfig.setUsername(user);
        }
        if (StringUtils.isNotEmpty((CharSequence)password)) {
            replicatedServersConfig.setPassword(password);
        }
        if ((dataBase = this.getDataBase(redisUri)) != null) {
            replicatedServersConfig.setDatabase(dataBase.intValue());
        }
        return Redisson.create((Config)config);
    }

    private List<String> getRedisHostAndPort(String redisUri) {
        String[] hostAndPortArr;
        int i;
        ArrayList<String> result = new ArrayList<String>();
        String substring = null;
        if (redisUri.contains("@")) {
            i = redisUri.indexOf(64);
            if (i != -1) {
                substring = redisUri.substring(i + 1);
            }
        } else {
            i = redisUri.indexOf("redis://");
            if (i != -1) {
                substring = redisUri.substring(i + 7 + 1);
            }
        }
        if (substring == null) {
            return result;
        }
        String[] split = substring.split("/");
        String hostAndPortStr = split[0];
        for (String hostAndPort : hostAndPortArr = hostAndPortStr.split(",")) {
            result.add("redis://" + hostAndPort);
        }
        return result;
    }

    private Pair<String, String> getUserNameAndPassword(String redisUri) {
        String user = "";
        String password = "";
        Pattern pattern = Pattern.compile(USERNAME_AND_PASSWORD_REGEX);
        Matcher matcher = pattern.matcher(redisUri);
        if (matcher.matches()) {
            String group = matcher.group(1);
            String[] split = group.split(":");
            int len = split.length;
            if (len > 0) {
                user = split[0];
            }
            if (len > 1) {
                password = split[1];
            }
        }
        return new MutablePair((Object)user, (Object)password);
    }

    private Integer getDataBase(String redisUri) {
        String group;
        Integer database = null;
        Pattern pattern = Pattern.compile(DATABASE_REGEX);
        Matcher matcher = pattern.matcher(redisUri);
        if (matcher.matches() && StringUtils.isNotBlank((CharSequence)(group = matcher.group(2)))) {
            database = Integer.valueOf(group);
        }
        return database;
    }
}

