/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.common.cache;

import com.arextest.common.cache.AbstractRedisCacheProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;

public class SentinelRedisCacheProvider
extends AbstractRedisCacheProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentinelRedisCacheProvider.class);
    private static final String USERNAME_AND_PASSWORD_REGEX = "redis://(.*?)@(.*?)";
    private static final String DATABASE_REGEX = "redis://(.*?)/(.*?)";

    public SentinelRedisCacheProvider() {
        this.jedisPool = new JedisPool();
    }

    public SentinelRedisCacheProvider(String redisHost) {
        String password;
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(1024);
        jedisPoolConfig.setMaxIdle(100);
        jedisPoolConfig.setMaxWaitMillis(100L);
        jedisPoolConfig.setTestOnBorrow(false);
        jedisPoolConfig.setTestOnReturn(true);
        Pair<String, String> userNameAndPassword = this.getUserNameAndPassword(redisHost);
        String masterName = (String)userNameAndPassword.getLeft();
        String string = password = StringUtils.isEmpty((CharSequence)((CharSequence)userNameAndPassword.getRight())) ? null : (String)userNameAndPassword.getRight();
        if (StringUtils.isEmpty((CharSequence)masterName)) {
            throw new RuntimeException("the master name is empty");
        }
        List<String> redisHostAndPort = this.getRedisHostAndPort(redisHost);
        if (CollectionUtils.isEmpty(redisHostAndPort)) {
            throw new RuntimeException("the redis host and port is empty");
        }
        Integer dataBase = this.getDataBase(redisHost);
        int targetDataBase = dataBase != null ? dataBase : 0;
        this.jedisPool = new JedisSentinelPool(masterName, new HashSet<String>(redisHostAndPort), (GenericObjectPoolConfig)jedisPoolConfig, 2000, password, targetDataBase);
        this.redissonClient = this.createRedissonClientByAnalyze(userNameAndPassword, redisHostAndPort, targetDataBase);
    }

    private Pair<String, String> getUserNameAndPassword(String redisUri) {
        String user = "";
        String password = "";
        Pattern pattern = Pattern.compile(USERNAME_AND_PASSWORD_REGEX);
        Matcher matcher = pattern.matcher(redisUri);
        if (matcher.matches()) {
            String group = matcher.group(1);
            String[] split = group.split(":");
            int len = split.length;
            if (len > 0) {
                user = split[0];
            }
            if (len > 1) {
                password = split[1];
            }
        }
        return new MutablePair((Object)user, (Object)password);
    }

    private List<String> getRedisHostAndPort(String redisUri) {
        int i;
        ArrayList<String> result = new ArrayList<String>();
        String substring = null;
        if (redisUri.contains("@")) {
            i = redisUri.indexOf(64);
            if (i != -1) {
                substring = redisUri.substring(i + 1);
            }
        } else {
            i = redisUri.indexOf("redis://");
            if (i != -1) {
                substring = redisUri.substring(i + 7 + 1);
            }
        }
        if (substring == null) {
            return result;
        }
        String[] split = substring.split("/");
        String hostAndPortStr = split[0];
        String[] hostAndPortArr = hostAndPortStr.split(",");
        result.addAll(Arrays.asList(hostAndPortArr));
        return result;
    }

    private RedissonClient createRedissonClientByAnalyze(Pair<String, String> userNameAndPassword, List<String> redisHostAndPort, Integer dataBase) {
        String masterName = (String)userNameAndPassword.getLeft();
        String password = (String)userNameAndPassword.getRight();
        Config config = new Config();
        SentinelServersConfig sentinelServersConfig = config.useSentinelServers();
        sentinelServersConfig.setMasterName(masterName).setDatabase(dataBase.intValue()).setCheckSentinelsList(false);
        if (StringUtils.isNotEmpty((CharSequence)password)) {
            sentinelServersConfig.setPassword(password);
        }
        for (String item : redisHostAndPort) {
            sentinelServersConfig.addSentinelAddress(new String[]{"redis://" + item});
        }
        return Redisson.create((Config)config);
    }

    private Integer getDataBase(String redisUri) {
        String group;
        Integer database = null;
        Pattern pattern = Pattern.compile(DATABASE_REGEX);
        Matcher matcher = pattern.matcher(redisUri);
        if (matcher.matches() && StringUtils.isNotBlank((CharSequence)(group = matcher.group(2)))) {
            database = Integer.valueOf(group);
        }
        return database;
    }
}

