/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.common.cache.redistemplate;

import com.arextest.common.cache.CacheProvider;
import com.arextest.common.cache.LockWrapper;
import com.arextest.common.cache.RedissonLock;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RedissonClient;
import org.springframework.data.redis.core.RedisTemplate;

public abstract class AbstractRedisTemplateProvider
implements CacheProvider {
    private final RedisTemplate<byte[], byte[]> byteRedisTemplate;
    private final RedissonClient redissonClient;

    @Override
    public boolean put(byte[] key, long expiredSeconds, byte[] value) {
        this.byteRedisTemplate.opsForValue().set((Object)key, (Object)value, expiredSeconds, TimeUnit.SECONDS);
        return true;
    }

    @Override
    public boolean put(byte[] key, byte[] value) {
        this.byteRedisTemplate.opsForValue().set((Object)key, (Object)value);
        return true;
    }

    @Override
    public boolean putIfAbsent(byte[] key, long expiredSeconds, byte[] value) {
        return this.byteRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, expiredSeconds, TimeUnit.SECONDS);
    }

    @Override
    public byte[] get(byte[] key) {
        return (byte[])this.byteRedisTemplate.opsForValue().get((Object)key);
    }

    @Override
    public long incrValue(byte[] key) {
        return this.byteRedisTemplate.opsForValue().increment((Object)key);
    }

    @Override
    public long incrValueBy(byte[] key, long value) {
        return this.byteRedisTemplate.opsForValue().increment((Object)key, value);
    }

    @Override
    public long decrValue(byte[] key) {
        return this.byteRedisTemplate.opsForValue().decrement((Object)key);
    }

    @Override
    public long decrValueBy(byte[] key, long value) {
        return this.byteRedisTemplate.opsForValue().decrement((Object)key, value);
    }

    @Override
    public boolean remove(byte[] key) {
        return this.byteRedisTemplate.delete((Object)key);
    }

    @Override
    public boolean expire(byte[] key, long seconds) {
        return this.byteRedisTemplate.expire((Object)key, seconds, TimeUnit.SECONDS);
    }

    @Override
    public LockWrapper getLock(String namespaceId) {
        return new RedissonLock(this.redissonClient.getLock(namespaceId));
    }

    @Override
    public RedissonClient getRedissionClient() {
        return this.redissonClient;
    }

    public AbstractRedisTemplateProvider(RedisTemplate<byte[], byte[]> byteRedisTemplate, RedissonClient redissonClient) {
        this.byteRedisTemplate = byteRedisTemplate;
        this.redissonClient = redissonClient;
    }
}

