/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.common.filter;

import com.arextest.common.metrics.MetricListener;
import com.arextest.common.utils.MetricUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentFilter.class);
    private final List<MetricListener> metricListeners;
    private final boolean recordPayloadWithMetric;
    private static Method getContentMethod;
    private static AtomicBoolean methodInitialized;

    public ContentFilter(List<MetricListener> metricListeners, boolean recordPayloadWithMetric) {
        this.metricListeners = metricListeners;
        this.recordPayloadWithMetric = recordPayloadWithMetric;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (CollectionUtils.isEmpty(this.metricListeners)) {
            chain.doFilter(request, response);
            return;
        }
        if (this.skipMetric(((HttpServletRequest)request).getMethod())) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        chain.doFilter((ServletRequest)httpServletRequest, response);
        this.logResponseSize(httpServletRequest, response);
    }

    private void logResponseSize(HttpServletRequest httpServletRequest, ServletResponse servletResponse) {
        String clientApp = httpServletRequest.getHeader("client-app");
        String category = httpServletRequest.getHeader("category-type");
        String requestURI = httpServletRequest.getRequestURI();
        long requestLength = httpServletRequest.getContentLengthLong();
        long responseLength = this.getResponseLength(servletResponse);
        this.recordPayloadInfo(clientApp, category, requestURI, requestLength, responseLength);
    }

    private long getResponseLength(ServletResponse servletResponse) {
        Class<?> responseClass = servletResponse.getClass();
        String responseClassName = responseClass.getName();
        if ("org.mortbay.jetty.Response".equals(responseClassName)) {
            return ContentFilter.getResponseLengthByMethod(servletResponse, "getContentCount");
        }
        if ("org.apache.catalina.connector.ResponseFacade".equals(responseClassName)) {
            return ContentFilter.getResponseLengthByMethod(servletResponse, "getContentWritten");
        }
        return 0L;
    }

    private static long getResponseLengthByMethod(ServletResponse servletResponse, String methodName) {
        if (methodInitialized.get()) {
            return ContentFilter.invokeMethod(servletResponse);
        }
        try {
            getContentMethod = servletResponse.getClass().getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("failed to get declared method. {}", (Object)e.getMessage(), (Object)e);
        }
        methodInitialized.set(true);
        return ContentFilter.invokeMethod(servletResponse);
    }

    private static long invokeMethod(ServletResponse servletResponse) {
        if (getContentMethod == null) {
            return 0L;
        }
        try {
            return (Long)getContentMethod.invoke((Object)servletResponse, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOGGER.error("failed to log response size. {}", (Object)e.getMessage(), (Object)e);
            return 0L;
        }
    }

    private void recordPayloadInfo(String clientApp, String category, String path, long requestLength, long responseLength) {
        if (responseLength <= 0L || requestLength <= 0L) {
            return;
        }
        HashMap<String, String> tags = new HashMap<String, String>();
        MetricUtils.putIfValueNotEmpty(clientApp, "clientApp", tags);
        MetricUtils.putIfValueNotEmpty(category, "category", tags);
        MetricUtils.putIfValueNotEmpty(path, "path", tags);
        for (MetricListener metricListener : this.metricListeners) {
            tags.put("type", "request");
            metricListener.recordSize("service.entry.payload", tags, requestLength);
            tags.put("type", "response");
            metricListener.recordSize("service.entry.payload", tags, responseLength);
        }
    }

    public void destroy() {
    }

    private boolean skipMetric(String method) {
        return StringUtils.isEmpty((CharSequence)method) || "GET".equalsIgnoreCase(method) || !this.recordPayloadWithMetric;
    }

    static {
        methodInitialized = new AtomicBoolean(false);
    }
}

