/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.common.interceptor;

import com.arextest.common.metrics.MetricListener;
import com.arextest.common.utils.MetricUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class MetricInterceptor
implements HandlerInterceptor {
    public final List<MetricListener> metricListeners;

    public MetricInterceptor(List<MetricListener> metricListeners) {
        this.metricListeners = metricListeners;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        request.setAttribute("startTime", (Object)System.currentTimeMillis());
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws IOException {
        Object startTime = request.getAttribute("startTime");
        if (startTime == null) {
            return;
        }
        long executeMillis = System.currentTimeMillis() - (Long)startTime;
        this.recordExecuteMillis(request.getHeader("client-app"), request.getHeader("category-type"), request.getRequestURI(), executeMillis);
    }

    public void recordExecuteMillis(String clientApp, String category, String path, long executeMillis) {
        if (CollectionUtils.isEmpty(this.metricListeners)) {
            return;
        }
        HashMap<String, String> tags = new HashMap<String, String>();
        MetricUtils.putIfValueNotEmpty(clientApp, "clientApp", tags);
        MetricUtils.putIfValueNotEmpty(category, "category", tags);
        MetricUtils.putIfValueNotEmpty(path, "path", tags);
        for (MetricListener metricListener : this.metricListeners) {
            if (executeMillis <= 0L) continue;
            metricListener.recordTime("service.entry.payload", tags, executeMillis);
        }
    }
}

