/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.common.jwt;

import com.arextest.common.jwt.JWTService;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class JWTServiceImpl
implements JWTService {
    private long accessExpireTime;
    private long refreshExpireTime;
    private String tokenSecret;

    @Override
    public String makeAccessToken(String username) {
        Date date = new Date(System.currentTimeMillis() + this.accessExpireTime);
        Algorithm algorithm = Algorithm.HMAC256((String)this.tokenSecret);
        return JWT.create().withExpiresAt(date).withClaim("username", username).sign(algorithm);
    }

    @Override
    public String makeAccessToken(String username, long expireTime) {
        Date date = new Date(System.currentTimeMillis() + expireTime);
        Algorithm algorithm = Algorithm.HMAC256((String)this.tokenSecret);
        return JWT.create().withExpiresAt(date).withClaim("username", username).sign(algorithm);
    }

    @Override
    public String makeRefreshToken(String username) {
        Date date = new Date(System.currentTimeMillis() + this.refreshExpireTime);
        Algorithm algorithm = Algorithm.HMAC256((String)this.tokenSecret);
        return JWT.create().withExpiresAt(date).withClaim("username", username).sign(algorithm);
    }

    @Override
    public boolean verifyToken(String field) {
        if (StringUtils.isEmpty((CharSequence)field)) {
            return false;
        }
        return this.getToken(field) != null;
    }

    @Override
    public String getUserName(String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            return null;
        }
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)this.tokenSecret);
            JWTVerifier build = JWT.require((Algorithm)algorithm).build();
            DecodedJWT verify = build.verify(token);
            return verify.getClaim("username").asString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private DecodedJWT getToken(String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            return null;
        }
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)this.tokenSecret);
            JWTVerifier build = JWT.require((Algorithm)algorithm).build();
            return build.verify(token);
        }
        catch (Exception e) {
            return null;
        }
    }

    public long getAccessExpireTime() {
        return this.accessExpireTime;
    }

    public long getRefreshExpireTime() {
        return this.refreshExpireTime;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    public void setAccessExpireTime(long accessExpireTime) {
        this.accessExpireTime = accessExpireTime;
    }

    public void setRefreshExpireTime(long refreshExpireTime) {
        this.refreshExpireTime = refreshExpireTime;
    }

    public void setTokenSecret(String tokenSecret) {
        this.tokenSecret = tokenSecret;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JWTServiceImpl)) {
            return false;
        }
        JWTServiceImpl other = (JWTServiceImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAccessExpireTime() != other.getAccessExpireTime()) {
            return false;
        }
        if (this.getRefreshExpireTime() != other.getRefreshExpireTime()) {
            return false;
        }
        String this$tokenSecret = this.getTokenSecret();
        String other$tokenSecret = other.getTokenSecret();
        return !(this$tokenSecret == null ? other$tokenSecret != null : !this$tokenSecret.equals(other$tokenSecret));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JWTServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $accessExpireTime = this.getAccessExpireTime();
        result = result * 59 + (int)($accessExpireTime >>> 32 ^ $accessExpireTime);
        long $refreshExpireTime = this.getRefreshExpireTime();
        result = result * 59 + (int)($refreshExpireTime >>> 32 ^ $refreshExpireTime);
        String $tokenSecret = this.getTokenSecret();
        result = result * 59 + ($tokenSecret == null ? 43 : $tokenSecret.hashCode());
        return result;
    }

    public String toString() {
        return "JWTServiceImpl(accessExpireTime=" + this.getAccessExpireTime() + ", refreshExpireTime=" + this.getRefreshExpireTime() + ", tokenSecret=" + this.getTokenSecret() + ")";
    }

    public JWTServiceImpl() {
    }

    public JWTServiceImpl(long accessExpireTime, long refreshExpireTime, String tokenSecret) {
        this.accessExpireTime = accessExpireTime;
        this.refreshExpireTime = refreshExpireTime;
        this.tokenSecret = tokenSecret;
    }
}

