/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.common.plugins;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.nosql.NoSqlProvider;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.mongodb4.MongoDb4Connection;
import org.apache.logging.log4j.mongodb4.MongoDb4DocumentObject;
import org.apache.logging.log4j.mongodb4.MongoDb4LevelCodec;
import org.apache.logging.log4j.status.StatusLogger;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

@Plugin(name="ArexMongoDb4", category="Core", printObject=true)
public final class MongoDb4Provider
implements NoSqlProvider<MongoDb4Connection> {
    private static final String COLLECTION_NAME = "logs";
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final CodecRegistry CODEC_REGISTRIES = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{CodecRegistries.fromCodecs((Codec[])new Codec[]{new Codec<MongoDb4DocumentObject>(){
        private Codec<Document> documentCodec = new DocumentCodec();

        public void encode(BsonWriter writer, MongoDb4DocumentObject value, EncoderContext encoderContext) {
            this.documentCodec.encode(writer, (Object)value.unwrap(), encoderContext);
        }

        public Class<MongoDb4DocumentObject> getEncoderClass() {
            return MongoDb4DocumentObject.class;
        }

        public MongoDb4DocumentObject decode(BsonReader reader, DecoderContext decoderContext) {
            MongoDb4DocumentObject object = new MongoDb4DocumentObject();
            Document document = (Document)this.documentCodec.decode(reader, decoderContext);
            for (Map.Entry entry : document.entrySet()) {
                object.set((String)entry.getKey(), entry.getValue());
            }
            return object;
        }
    }}), MongoClientSettings.getDefaultCodecRegistry(), CodecRegistries.fromCodecs((Codec[])new Codec[]{MongoDb4LevelCodec.INSTANCE})});
    private static final int DEFAULT_COLLECTION_SIZE = 0x20000000;
    private final Integer collectionSize;
    private final boolean isCapped;
    private final MongoClient mongoClient;
    private final MongoDatabase mongoDatabase;
    private final ConnectionString connectionString;

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    private MongoDb4Provider(String connectionStringSource, boolean isCapped, Integer collectionSize) {
        String cSource = this.addCollectionNameToConnectionString(connectionStringSource);
        this.connectionString = new ConnectionString(cSource);
        MongoClientSettings settings = MongoClientSettings.builder().applyConnectionString(this.connectionString).codecRegistry(CODEC_REGISTRIES).build();
        this.mongoClient = MongoClients.create((MongoClientSettings)settings);
        String databaseName = this.connectionString.getDatabase();
        this.mongoDatabase = this.mongoClient.getDatabase(databaseName);
        this.isCapped = isCapped;
        this.collectionSize = collectionSize;
    }

    public MongoDb4Connection getConnection() {
        return new MongoDb4Connection(this.connectionString, this.mongoClient, this.mongoDatabase, this.isCapped, this.collectionSize);
    }

    public String toString() {
        return String.format("%s [connectionString=%s, collectionSize=%s, isCapped=%s, mongoClient=%s, mongoDatabase=%s]", MongoDb4Provider.class.getSimpleName(), this.connectionString, this.collectionSize, this.isCapped, this.mongoClient, this.mongoDatabase);
    }

    private String addCollectionNameToConnectionString(String connectionStringSource) {
        if (connectionStringSource.indexOf("?") == -1) {
            return connectionStringSource + "." + COLLECTION_NAME;
        }
        return connectionStringSource.substring(0, connectionStringSource.indexOf("?")) + "." + COLLECTION_NAME + connectionStringSource.substring(connectionStringSource.indexOf("?"));
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractFilterable.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<MongoDb4Provider> {
        @PluginBuilderAttribute(value="connection")
        @Required(message="No connection string provided")
        private String connectionStringSource;
        @PluginBuilderAttribute
        private int collectionSize = 0x20000000;
        @PluginBuilderAttribute(value="capped")
        private boolean capped = false;

        public MongoDb4Provider build() {
            return new MongoDb4Provider(this.connectionStringSource, this.capped, this.collectionSize);
        }

        public B setCapped(boolean isCapped) {
            this.capped = isCapped;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setCollectionSize(int collectionSize) {
            this.collectionSize = collectionSize;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }
}

