/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.common.runnable;

import com.arextest.common.model.TenantContext;
import com.arextest.common.utils.TenantContextUtil;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class AbstractContextWithTraceRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractContextWithTraceRunnable.class);
    private final Map<String, String> traceMap = MDC.getCopyOfContextMap();
    private final TenantContext tenantContext = TenantContextUtil.getAll();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Map<String, String> old = this.mark();
        TenantContext oldContext = this.markContext();
        try {
            this.doWithContextRunning();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.removeMark(old);
            this.removeContext(oldContext);
        }
    }

    protected abstract void doWithContextRunning();

    private Map<String, String> mark() {
        if (MapUtils.isEmpty(this.traceMap)) {
            return null;
        }
        Map old = MDC.getCopyOfContextMap();
        MDC.setContextMap(this.traceMap);
        return old;
    }

    private void removeMark(Map<String, String> prev) {
        if (MapUtils.isEmpty(prev)) {
            MDC.clear();
        } else {
            MDC.setContextMap(prev);
        }
    }

    private TenantContext markContext() {
        if (this.tenantContext == null) {
            return null;
        }
        TenantContext tenantContext = TenantContextUtil.getCopyOfAll();
        TenantContextUtil.setAll(this.tenantContext);
        return tenantContext;
    }

    private void removeContext(TenantContext tenantContext) {
        if (tenantContext == null) {
            TenantContextUtil.clearAll();
        } else {
            TenantContextUtil.setAll(tenantContext);
        }
    }
}

