/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.common.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;

public class JsonTraverseUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String trimAllLeaves(String in) throws JsonProcessingException {
        if (StringUtils.isEmpty((CharSequence)in)) {
            return in;
        }
        JsonNode root = OBJECT_MAPPER.readTree(in);
        JsonTraverseUtils.trimNode(null, root, null);
        return root.toString();
    }

    private static void trimNode(String fieldName, JsonNode node, JsonNode parent) {
        if (node == null || node.isNull()) {
            return;
        }
        if (node.isObject()) {
            node.fields().forEachRemaining(field -> JsonTraverseUtils.trimNode((String)field.getKey(), (JsonNode)field.getValue(), node));
        } else if (node.isArray()) {
            int idx = 0;
            Iterator arrIter = node.elements();
            while (arrIter.hasNext()) {
                JsonNode currentElement = (JsonNode)arrIter.next();
                if (currentElement.isObject() || currentElement.isArray()) {
                    JsonTraverseUtils.trimNode(null, currentElement, null);
                } else {
                    ((ArrayNode)node).set(idx, (JsonNode)JsonNodeFactory.instance.nullNode());
                }
                ++idx;
            }
        } else {
            ((ObjectNode)parent).putNull(fieldName);
        }
    }
}

