/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.common.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class JwtUtil {
    private static final long ACCESS_EXPIRE_TIME = 604800000L;
    private static final long REFRESH_EXPIRE_TIME = 2592000000L;
    private static final String TOKEN_SECRET = System.getProperty("arex.jwt.secret", "arex");

    public static String makeAccessToken(String username) {
        Date date = new Date(System.currentTimeMillis() + 604800000L);
        Algorithm algorithm = Algorithm.HMAC256((String)TOKEN_SECRET);
        return JWT.create().withExpiresAt(date).withClaim("username", username).sign(algorithm);
    }

    public static String makeRefreshToken(String username) {
        Date date = new Date(System.currentTimeMillis() + 2592000000L);
        Algorithm algorithm = Algorithm.HMAC256((String)TOKEN_SECRET);
        return JWT.create().withExpiresAt(date).withClaim("username", username).sign(algorithm);
    }

    public static boolean verifyToken(String field) {
        if (StringUtils.isEmpty((CharSequence)field)) {
            return false;
        }
        return JwtUtil.getToken(field) != null;
    }

    public static String getUserName(String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            return null;
        }
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)TOKEN_SECRET);
            JWTVerifier build = JWT.require((Algorithm)algorithm).build();
            DecodedJWT verify = build.verify(token);
            return verify.getClaim("username").asString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static DecodedJWT getToken(String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            return null;
        }
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)TOKEN_SECRET);
            JWTVerifier build = JWT.require((Algorithm)algorithm).build();
            return build.verify(token);
        }
        catch (Exception e) {
            return null;
        }
    }
}

