/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.common.utils;

import com.arextest.common.model.classloader.RemoteJarClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteJarLoaderUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteJarLoaderUtils.class);

    public static RemoteJarClassLoader loadJar(String jarUrl) throws MalformedURLException {
        URL resource = jarUrl.startsWith("http") ? new URL(jarUrl) : RemoteJarLoaderUtils.class.getClassLoader().getResource(jarUrl);
        if (resource == null) {
            resource = new File(jarUrl).toURI().toURL();
        }
        try {
            URLConnection urlConnection = resource.openConnection();
            urlConnection.getInputStream().close();
        }
        catch (IOException e) {
            LOGGER.error("Failed to load jar: {}", (Object)jarUrl, (Object)e);
            throw new RuntimeException("Failed to load jar: " + jarUrl, e);
        }
        return new RemoteJarClassLoader(new URL[]{resource}, RemoteJarLoaderUtils.class.getClassLoader());
    }

    public static <T> List<T> loadService(Class<T> clazz, SecureClassLoader classLoader) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz, classLoader);
        ArrayList<T> res = new ArrayList<T>();
        Iterator<T> iterator = serviceLoader.iterator();
        while (iterator.hasNext()) {
            res.add(iterator.next());
        }
        return res;
    }
}

