/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.common.utils;

import com.arextest.common.model.response.GenericResponseType;
import com.arextest.common.model.response.Response;
import com.arextest.common.model.response.ResponseCode;
import com.arextest.common.model.response.ResponseStatusType;

public class ResponseUtils_New {
    private static final String REQUESTED_BODY_EMPTY = "requested body empty";
    private static final String SUCCESS = "success";

    private ResponseUtils_New() {
    }

    public static Response exceptionResponse(String remark) {
        return ResponseUtils_New.errorResponse(remark, 2);
    }

    public static Response errorResponse(String remark, int responseCode) {
        return ResponseUtils_New.errorResponse(ResponseUtils_New.responseStatus(remark, responseCode));
    }

    public static Response errorResponse(ResponseStatusType responseStatusType) {
        return ResponseUtils_New.create(responseStatusType, null);
    }

    public static <T> Response successResponse(T body) {
        return ResponseUtils_New.create(ResponseUtils_New.successStatus(), body);
    }

    public static <T> Response create(ResponseStatusType statusType, T body) {
        return new GenericResponseType<T>(statusType, body);
    }

    public static Response resourceNotFoundResponse() {
        return ResponseUtils_New.errorResponse(ResponseCode.REQUESTED_RESOURCE_NOT_FOUND.name(), 3);
    }

    public static Response parameterInvalidResponse(String remark) {
        return ResponseUtils_New.errorResponse(remark, 1);
    }

    public static ResponseStatusType successStatus() {
        return ResponseUtils_New.responseStatus(SUCCESS, 0);
    }

    public static Response requestBodyEmptyResponse() {
        return ResponseUtils_New.parameterInvalidResponse(REQUESTED_BODY_EMPTY);
    }

    private static ResponseStatusType responseStatus(String remark, int responseCode) {
        ResponseStatusType responseStatusType = new ResponseStatusType();
        responseStatusType.setResponseDesc(remark);
        responseStatusType.setResponseCode(responseCode);
        responseStatusType.setTimestamp(System.currentTimeMillis());
        return responseStatusType;
    }
}

