/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.common.utils;

import com.arextest.common.serialization.SerializationProviders;
import com.arextest.common.serialization.SerializationReader;
import com.arextest.common.serialization.SerializationWriter;
import com.arextest.common.utils.StreamWrapUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SerializationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializationUtils.class);
    public static final byte[] EMPTY_INSTANCE = new byte[]{40, -75, 47, -3, 0, 80, 17, 0, 0, 123, 125};

    private SerializationUtils() {
    }

    public static <T> void useZstdSerializeTo(OutputStream outputStream, T value) {
        SerializationUtils.useZstdSerializeTo(SerializationProviders.DEFAULT_PROVIDER, outputStream, value);
    }

    public static <T> void useZstdSerializeTo(SerializationWriter serializationWriter, OutputStream outputStream, T value) {
        try (OutputStream zstdOutputStream = StreamWrapUtils.wrapZstd(outputStream);){
            serializationWriter.writeValue(zstdOutputStream, value);
        }
        catch (IOException e) {
            LOGGER.error("serialize error:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static <T> byte[] useZstdSerializeToBytes(T value) {
        byte[] byArray;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            SerializationUtils.useZstdSerializeTo(out, value);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("serialize error:{}", (Object)e.getMessage(), (Object)e);
                return null;
            }
        }
        out.close();
        return byArray;
    }

    public static <T> String useZstdSerializeToBase64(T value) {
        String string;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            SerializationUtils.useZstdSerializeTo(StreamWrapUtils.wrapBase64(out), value);
            string = out.toString(StandardCharsets.UTF_8.name());
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("serialize error:{}", (Object)e.getMessage(), (Object)e);
                return null;
            }
        }
        out.close();
        return string;
    }

    public static <T> T useZstdDeserialize(InputStream inputStream, Class<T> clazz) {
        return SerializationUtils.useZstdDeserialize((SerializationReader)SerializationProviders.DEFAULT_PROVIDER, inputStream, clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T useZstdDeserialize(SerializationReader serializationReader, InputStream inputStream, Class<T> clazz) {
        try (InputStream zstdStream = StreamWrapUtils.wrapZstd(inputStream);){
            T t = serializationReader.readValue(zstdStream, clazz);
            return t;
        }
        catch (Throwable e) {
            LOGGER.error("deserialize error:{}, target:{}", new Object[]{e.getMessage(), clazz.getName(), e});
            return null;
        }
    }

    public static <T> T useZstdDeserialize(String base64Source, Class<T> clazz) {
        return SerializationUtils.useZstdDeserialize(StreamWrapUtils.decodeBase64(base64Source), clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T useZstdDeserialize(SerializationReader serializationReader, byte[] zstdValues, Class<T> clazz) {
        if (zstdValues == null) {
            return null;
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(zstdValues);){
            T t = SerializationUtils.useZstdDeserialize(serializationReader, (InputStream)inputStream, clazz);
            return t;
        }
        catch (Throwable e) {
            LOGGER.error("deserialize error:{}, target:{}", new Object[]{e.getMessage(), clazz.getName(), e});
            return null;
        }
    }

    public static <T> T useZstdDeserialize(byte[] zstdValues, Class<T> clazz) {
        return SerializationUtils.useZstdDeserialize((SerializationReader)SerializationProviders.DEFAULT_PROVIDER, zstdValues, clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T useZstdDeserialize(SerializationReader serializationReader, byte[] zstdValues, TypeReference<T> typeReference) {
        if (zstdValues == null) {
            return null;
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(zstdValues);){
            T t = SerializationUtils.useZstdDeserialize(serializationReader, (InputStream)inputStream, typeReference);
            return t;
        }
        catch (Exception e) {
            LOGGER.error("deserialize error:{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T useZstdDeserialize(SerializationReader serializationReader, InputStream inputStream, TypeReference<T> typeReference) {
        try (InputStream zstdStream = StreamWrapUtils.wrapZstd(inputStream);){
            T t = serializationReader.readValue(zstdStream, typeReference);
            return t;
        }
        catch (Exception e) {
            LOGGER.error("deserialize error:{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }
}

