/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.common.utils;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.arextest.common.model.TenantContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantContextUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantContextUtil.class);
    private static final TransmittableThreadLocal<TenantContext> LOCAL = new TransmittableThreadLocal();

    public static void setTenantCode(String tenantCode) {
        TenantContextUtil.getOrCreateContext().setTenantCode(tenantCode);
    }

    public static String getTenantCode() {
        return TenantContextUtil.getOrCreateContext().getTenantCode();
    }

    public static void setAll(TenantContext tenantContext) {
        LOCAL.set((Object)tenantContext);
    }

    public static TenantContext getAll() {
        return (TenantContext)LOCAL.get();
    }

    public static TenantContext getCopyOfAll() {
        TenantContext tenantContext = (TenantContext)LOCAL.get();
        if (tenantContext == null) {
            return null;
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return (TenantContext)objectMapper.readValue(objectMapper.writeValueAsString((Object)tenantContext), TenantContext.class);
        }
        catch (Exception e) {
            LOGGER.error("Failed to get copy of all", (Throwable)e);
            return null;
        }
    }

    public static void clearAll() {
        LOCAL.remove();
    }

    private static TenantContext getOrCreateContext() {
        if (LOCAL.get() == null) {
            LOCAL.set((Object)new TenantContext());
        }
        return (TenantContext)LOCAL.get();
    }
}

