/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.common.cache;

import com.arextest.common.cache.CacheProvider;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public final class DefaultRedisCacheProvider
implements CacheProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRedisCacheProvider.class);
    private static final String STATUS_CODE = "OK";
    private JedisPool jedisPool;

    public DefaultRedisCacheProvider() {
        this.jedisPool = new JedisPool();
    }

    public DefaultRedisCacheProvider(String redisHost) {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(1024);
        jedisPoolConfig.setMaxIdle(100);
        jedisPoolConfig.setMaxWaitMillis(100L);
        jedisPoolConfig.setTestOnBorrow(false);
        jedisPoolConfig.setTestOnReturn(true);
        try {
            this.jedisPool = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, new URI(redisHost));
        }
        catch (URISyntaxException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean put(byte[] key, long expiredSeconds, byte[] value) {
        try (Jedis jedis = this.jedisPool.getResource();){
            boolean bl = this.statusCode2Boolean(jedis.setex(key, (int)expiredSeconds, value));
            return bl;
        }
    }

    @Override
    public boolean put(byte[] key, byte[] value) {
        try (Jedis jedis = this.jedisPool.getResource();){
            boolean bl = this.statusCode2Boolean(jedis.set(key, value));
            return bl;
        }
    }

    @Override
    public boolean putIfAbsent(byte[] key, long expiredSeconds, byte[] value) {
        try (Jedis jedis = this.jedisPool.getResource();){
            boolean nxResult = this.integer2Boolean(jedis.setnx(key, value));
            if (nxResult) {
                this.expire(key, expiredSeconds);
            }
            boolean bl = nxResult;
            return bl;
        }
    }

    @Override
    public byte[] get(byte[] key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            byte[] byArray = jedis.get(key);
            return byArray;
        }
    }

    @Override
    public long incrValue(byte[] key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            long l = jedis.incr(key);
            return l;
        }
    }

    @Override
    public long decrValue(byte[] key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            long l = jedis.decr(key);
            return l;
        }
    }

    @Override
    public boolean remove(byte[] key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            boolean bl = this.integer2Boolean(jedis.del(key));
            return bl;
        }
    }

    @Override
    public boolean expire(byte[] key, long seconds) {
        try (Jedis jedis = this.jedisPool.getResource();){
            boolean bl = this.integer2Boolean(jedis.expire(key, (int)seconds));
            return bl;
        }
    }

    private boolean statusCode2Boolean(String statusCode) {
        return STATUS_CODE.equals(statusCode);
    }

    private boolean integer2Boolean(long l) {
        return l > 0L;
    }
}

