/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.common.serialization;

import com.arextest.common.serialization.SerializationProvider;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public final class SerializationProviders {
    private static final int ONE_K_BUFFER_SIZE = 1024;
    private static final ObjectMapper DEFAULT_JACKSON_MAPPER = new ObjectMapper();
    public static final SerializationProvider DEFAULT_PROVIDER = SerializationProviders.jacksonProvider(DEFAULT_JACKSON_MAPPER);
    public static final SerializationProvider UTF8_TEXT_PROVIDER = SerializationProviders.utf8TextProvider();

    private SerializationProviders() {
    }

    public static SerializationProvider jacksonProvider(ObjectMapper objectMapper) {
        return new JacksonSerializationProvider(objectMapper);
    }

    private static SerializationProvider utf8TextProvider() {
        return new Utf8StringSerializationProvider();
    }

    private static class JacksonSerializationProvider
    implements SerializationProvider {
        private final ObjectMapper jacksonMapper;

        private JacksonSerializationProvider(ObjectMapper jacksonMapper) {
            this.jacksonMapper = jacksonMapper;
            this.jacksonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }

        @Override
        public <T> void writeValue(OutputStream outputStream, T value) throws IOException {
            this.jacksonMapper.writeValue(outputStream, value);
        }

        @Override
        public <T> T readValue(InputStream inputStream, Class<T> valueClass) throws IOException {
            return (T)this.jacksonMapper.readValue(inputStream, valueClass);
        }
    }

    private static class Utf8StringSerializationProvider
    implements SerializationProvider {
        private Utf8StringSerializationProvider() {
        }

        @Override
        public <T> void writeValue(OutputStream outputStream, T value) throws IOException {
            if (value instanceof String) {
                StringReader stringReader = new StringReader((String)value);
                IOUtils.copy((Reader)stringReader, (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
                outputStream.close();
            }
        }

        @Override
        public <T> T readValue(InputStream inputStream, Class<T> valueClass) throws IOException {
            int n;
            if (valueClass != String.class) {
                return null;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            byte[] buffer = new byte[1024];
            while ((n = inputStream.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
            return (T)out.toString(StandardCharsets.UTF_8.name());
        }
    }
}

