/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.common.utils;

import com.arextest.common.serialization.SerializationProviders;
import com.arextest.common.serialization.SerializationReader;
import com.arextest.common.utils.SerializationUtils;
import com.arextest.common.utils.StreamWrapUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompressionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompressionUtils.class);

    private CompressionUtils() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String useZstdCompress(String source) {
        if (StringUtils.isEmpty((CharSequence)source)) {
            return source;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            String string;
            block14: {
                OutputStream base64Stream = StreamWrapUtils.wrapBase64(out);
                try {
                    SerializationUtils.useZstdSerializeTo(SerializationProviders.UTF8_TEXT_PROVIDER, base64Stream, source);
                    string = out.toString(StandardCharsets.UTF_8.name());
                    if (base64Stream == null) break block14;
                }
                catch (Throwable throwable) {
                    if (base64Stream != null) {
                        try {
                            base64Stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                base64Stream.close();
            }
            return string;
        }
        catch (Throwable e) {
            LOGGER.error("zstd compress error:{},source:{}", new Object[]{e.getMessage(), source, e});
            return null;
        }
    }

    public static String useZstdDecompress(String base64Source) {
        if (StringUtils.isEmpty((CharSequence)base64Source)) {
            return base64Source;
        }
        byte[] base64Bytes = StreamWrapUtils.decodeBase64(base64Source);
        return SerializationUtils.useZstdDeserialize((SerializationReader)SerializationProviders.UTF8_TEXT_PROVIDER, base64Bytes, String.class);
    }

    public static String encodeToBase64String(byte[] value) {
        if (value == null) {
            return null;
        }
        return Base64.getEncoder().encodeToString(value);
    }
}

