/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.common.utils;

import com.arextest.common.model.response.GenericResponseType;
import com.arextest.common.model.response.Response;
import com.arextest.common.model.response.ResponseCode;
import com.arextest.common.model.response.ResponseStatusType;

public final class ResponseUtils {
    private static final String REQUESTED_BODY_EMPTY = "requested body empty";
    private static final String SUCCESS = "success";

    private ResponseUtils() {
    }

    public static Response exceptionResponse(String remark) {
        return ResponseUtils.errorResponse(remark, ResponseCode.REQUESTED_HANDLE_EXCEPTION);
    }

    public static Response errorResponse(String remark, ResponseCode responseCode) {
        return ResponseUtils.errorResponse(ResponseUtils.responseStatus(remark, responseCode));
    }

    public static Response errorResponse(ResponseStatusType responseStatusType) {
        return ResponseUtils.create(responseStatusType, null);
    }

    public static <T> Response successResponse(T body) {
        return ResponseUtils.create(ResponseUtils.successStatus(), body);
    }

    public static <T> Response create(ResponseStatusType statusType, T body) {
        return new GenericResponseType<T>(statusType, body);
    }

    public static Response resourceNotFoundResponse() {
        return ResponseUtils.errorResponse(ResponseCode.REQUESTED_RESOURCE_NOT_FOUND.name(), ResponseCode.REQUESTED_RESOURCE_NOT_FOUND);
    }

    public static Response parameterInvalidResponse(String remark) {
        return ResponseUtils.errorResponse(remark, ResponseCode.REQUESTED_PARAMETER_INVALID);
    }

    public static ResponseStatusType successStatus() {
        return ResponseUtils.responseStatus(SUCCESS, ResponseCode.SUCCESS);
    }

    public static Response requestBodyEmptyResponse() {
        return ResponseUtils.parameterInvalidResponse(REQUESTED_BODY_EMPTY);
    }

    private static ResponseStatusType responseStatus(String remark, ResponseCode responseCode) {
        ResponseStatusType responseStatusType = new ResponseStatusType();
        responseStatusType.setResponseDesc(remark);
        responseStatusType.setResponseCode(responseCode.getCodeValue());
        responseStatusType.setTimestamp(System.currentTimeMillis());
        return responseStatusType;
    }
}

