/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.model.mock;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class MockCategoryType {
    public static final Set<MockCategoryType> DEFAULTS;
    public static final MockCategoryType Q_MESSAGE_CONSUMER;
    public static final MockCategoryType Q_MESSAGE_PRODUCER;
    public static final MockCategoryType SERVLET;
    public static final MockCategoryType NETTY_PROVIDER;
    public static final MockCategoryType DATABASE;
    public static final MockCategoryType HTTP_CLIENT;
    public static final MockCategoryType CONFIG_FILE;
    public static final MockCategoryType DYNAMIC_CLASS;
    public static final MockCategoryType REDIS;
    public static final MockCategoryType DUBBO_PROVIDER;
    public static final MockCategoryType DUBBO_CONSUMER;
    public static final MockCategoryType COVERAGE;
    private String name;
    private boolean entryPoint;
    private boolean skipComparison;

    public static MockCategoryType createEntryPoint(String name) {
        return new MockCategoryType(name, true, false);
    }

    public static MockCategoryType createSkipComparison(String name) {
        return new MockCategoryType(name, false, true);
    }

    public static MockCategoryType createDependency(String name) {
        return new MockCategoryType(name, false, false);
    }

    public static MockCategoryType createCoverage(String name) {
        return new MockCategoryType(name, false, true);
    }

    public static MockCategoryType create(String name) {
        for (MockCategoryType categoryType : DEFAULTS) {
            if (!Objects.equals(categoryType.name, name)) continue;
            return categoryType;
        }
        return MockCategoryType.createDependency(name);
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEntryPoint() {
        return this.entryPoint;
    }

    public boolean isSkipComparison() {
        return this.skipComparison;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEntryPoint(boolean entryPoint) {
        this.entryPoint = entryPoint;
    }

    public void setSkipComparison(boolean skipComparison) {
        this.skipComparison = skipComparison;
    }

    public MockCategoryType() {
    }

    public MockCategoryType(String name, boolean entryPoint, boolean skipComparison) {
        this.name = name;
        this.entryPoint = entryPoint;
        this.skipComparison = skipComparison;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MockCategoryType)) {
            return false;
        }
        MockCategoryType other = (MockCategoryType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MockCategoryType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    static {
        Q_MESSAGE_CONSUMER = MockCategoryType.createEntryPoint("QMessageConsumer");
        Q_MESSAGE_PRODUCER = MockCategoryType.createDependency("QMessageProducer");
        SERVLET = MockCategoryType.createEntryPoint("Servlet");
        NETTY_PROVIDER = MockCategoryType.createEntryPoint("NettyProvider");
        DATABASE = MockCategoryType.createDependency("Database");
        HTTP_CLIENT = MockCategoryType.createDependency("HttpClient");
        CONFIG_FILE = MockCategoryType.createSkipComparison("ConfigFile");
        DYNAMIC_CLASS = MockCategoryType.createSkipComparison("DynamicClass");
        REDIS = MockCategoryType.createDependency("Redis");
        DUBBO_PROVIDER = MockCategoryType.createEntryPoint("DubboProvider");
        DUBBO_CONSUMER = MockCategoryType.createDependency("DubboConsumer");
        COVERAGE = MockCategoryType.createCoverage("Coverage");
        LinkedHashSet<MockCategoryType> internalSet = new LinkedHashSet<MockCategoryType>();
        internalSet.add(SERVLET);
        internalSet.add(NETTY_PROVIDER);
        internalSet.add(DUBBO_PROVIDER);
        internalSet.add(Q_MESSAGE_CONSUMER);
        internalSet.add(Q_MESSAGE_PRODUCER);
        internalSet.add(DATABASE);
        internalSet.add(HTTP_CLIENT);
        internalSet.add(CONFIG_FILE);
        internalSet.add(DYNAMIC_CLASS);
        internalSet.add(REDIS);
        internalSet.add(DUBBO_CONSUMER);
        DEFAULTS = Collections.unmodifiableSet(internalSet);
    }
}

