/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.config.mapper;

import com.arextest.config.model.dao.config.InstancesCollection;
import com.arextest.config.model.dto.application.InstancesConfiguration;
import com.arextest.config.model.vo.AgentRemoteConfigurationRequest;
import com.arextest.config.model.vo.AgentStatusRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;

@Mapper
public interface InstancesMapper {
    public static final String TAG_PREFIX = "arex.tags.";
    public static final InstancesMapper INSTANCE = (InstancesMapper)Mappers.getMapper(InstancesMapper.class);

    @Mappings(value={@Mapping(target="modifiedTime", expression="java(dao.getDataChangeUpdateTime() == null ? null : new java.sql.Timestamp(dao.getDataChangeUpdateTime()))")})
    public InstancesConfiguration dtoFromDao(InstancesCollection var1);

    public InstancesCollection daoFromDto(InstancesConfiguration var1);

    @Mappings(value={@Mapping(target="tags", source="systemProperties", qualifiedByName={"extractTags"})})
    public InstancesConfiguration dtoFromContract(AgentRemoteConfigurationRequest var1);

    public InstancesConfiguration dtoFromContract(AgentStatusRequest var1);

    @Named(value="extractTags")
    default public Map<String, String> extractTags(Map<String, String> systemProperties) {
        if (systemProperties == null || systemProperties.isEmpty()) {
            return null;
        }
        HashMap<String, String> tags = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : systemProperties.entrySet()) {
            String key = entry.getKey();
            Optional.ofNullable(key).ifPresent(k -> {
                if (k.startsWith(TAG_PREFIX)) {
                    String substring = key.substring(TAG_PREFIX.length());
                    if (substring.isEmpty()) {
                        return;
                    }
                    tags.put(substring, (String)entry.getValue());
                }
            });
        }
        return tags.isEmpty() ? null : tags;
    }
}

