/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.config.repository.impl;

import com.arextest.config.mapper.AppMapper;
import com.arextest.config.model.dao.config.AppCollection;
import com.arextest.config.model.dto.application.ApplicationConfiguration;
import com.arextest.config.repository.ConfigRepositoryProvider;
import com.arextest.config.utils.MongoHelper;
import com.mongodb.client.result.DeleteResult;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

public class ApplicationConfigurationRepositoryImpl
implements ConfigRepositoryProvider<ApplicationConfiguration> {
    private static final String DOT_OP = ".";
    private final MongoTemplate mongoTemplate;
    @Resource
    private List<ConfigRepositoryProvider<?>> configRepositoryProviders;

    public ApplicationConfigurationRepositoryImpl(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    @Override
    public List<ApplicationConfiguration> list() {
        Query query = new Query().with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"_id"}));
        return this.mongoTemplate.find(query, AppCollection.class).stream().map(AppMapper.INSTANCE::dtoFromDao).collect(Collectors.toList());
    }

    @Override
    public List<ApplicationConfiguration> listBy(String appId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"appId").is((Object)appId));
        List appCollections = this.mongoTemplate.find(query, AppCollection.class);
        return appCollections.stream().map(AppMapper.INSTANCE::dtoFromDao).collect(Collectors.toList());
    }

    @Override
    public boolean update(ApplicationConfiguration configuration) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)configuration.getAppId()));
        Update update = MongoHelper.getMongoTemplateUpdates(configuration, "agentVersion", "agentExtVersion", "status", "features", "appName", "owners", "visibilityLevel", "tags");
        MongoHelper.withMongoTemplateBaseUpdate(update);
        return this.mongoTemplate.updateMulti(filter, (UpdateDefinition)update, AppCollection.class).getModifiedCount() > 0L;
    }

    @Override
    public boolean remove(ApplicationConfiguration configuration) {
        if (StringUtils.isBlank((CharSequence)configuration.getAppId())) {
            return false;
        }
        return this.removeByAppId(configuration.getAppId());
    }

    @Override
    public boolean removeByAppId(String appId) {
        for (ConfigRepositoryProvider<?> configRepositoryProvider : this.configRepositoryProviders) {
            configRepositoryProvider.removeByAppId(appId);
        }
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)appId));
        DeleteResult deleteResult = this.mongoTemplate.remove(filter, AppCollection.class);
        return deleteResult.getDeletedCount() > 0L;
    }

    @Override
    public boolean insert(ApplicationConfiguration configuration) {
        this.mongoTemplate.insert((Object)AppMapper.INSTANCE.daoFromDto(configuration));
        return true;
    }

    public boolean addEnvToApp(String appId, Map<String, String> tags) {
        if (StringUtils.isBlank((CharSequence)appId) || tags == null || tags.isEmpty()) {
            return false;
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"appId").is((Object)appId));
        Update update = new Update();
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isBlank((CharSequence)value)) continue;
            update.addToSet("tags." + key, (Object)value);
        }
        if (update.getUpdateObject().isEmpty()) {
            return false;
        }
        return this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, AppCollection.class).getModifiedCount() > 0L;
    }
}

