/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.config.repository.impl;

import com.arextest.config.mapper.ServiceOperationMapper;
import com.arextest.config.model.dao.config.ServiceOperationCollection;
import com.arextest.config.model.dto.application.ApplicationOperationConfiguration;
import com.arextest.config.repository.ConfigRepositoryProvider;
import com.arextest.config.utils.MongoHelper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

public class ApplicationOperationConfigurationRepositoryImpl
implements ConfigRepositoryProvider<ApplicationOperationConfiguration> {
    private final MongoTemplate mongoTemplate;

    @Override
    public List<ApplicationOperationConfiguration> list() {
        throw new UnsupportedOperationException("this method is not implemented");
    }

    @Override
    public List<ApplicationOperationConfiguration> listBy(String appId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"appId").is((Object)appId));
        return this.mongoTemplate.find(query, ServiceOperationCollection.class).stream().map(ServiceOperationMapper.INSTANCE::dtoFromDao).collect(Collectors.toList());
    }

    @Override
    public boolean update(ApplicationOperationConfiguration configuration) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(configuration.getId())));
        Update update = MongoHelper.getMongoTemplateUpdates(configuration, "status");
        MongoHelper.withMongoTemplateBaseUpdate(update);
        return this.mongoTemplate.updateMulti(query, (UpdateDefinition)update, ServiceOperationCollection.class).getModifiedCount() > 0L;
    }

    @Override
    public boolean remove(ApplicationOperationConfiguration configuration) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(configuration.getId())));
        return this.mongoTemplate.remove(filter, ServiceOperationCollection.class).getDeletedCount() > 0L;
    }

    @Override
    public boolean insert(ApplicationOperationConfiguration configuration) {
        ServiceOperationCollection inserted = (ServiceOperationCollection)this.mongoTemplate.insert((Object)ServiceOperationMapper.INSTANCE.daoFromDto(configuration));
        if (inserted.getId() != null) {
            configuration.setId(inserted.getId());
        }
        return inserted.getId() != null;
    }

    public ApplicationOperationConfiguration listByOperationId(String operationId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(operationId)));
        return Optional.ofNullable((ServiceOperationCollection)this.mongoTemplate.findOne(query, ServiceOperationCollection.class)).map(ServiceOperationMapper.INSTANCE::dtoFromDao).orElse(null);
    }

    public List<ApplicationOperationConfiguration> operationBaseInfoList(String serviceId) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"serviceId").is((Object)serviceId));
        return this.mongoTemplate.find(filter, ServiceOperationCollection.class).stream().map(ServiceOperationMapper.INSTANCE::baseInfoFromDao).collect(Collectors.toList());
    }

    @Override
    public boolean removeByAppId(String appId) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)appId));
        return this.mongoTemplate.remove(filter, ServiceOperationCollection.class).getDeletedCount() > 0L;
    }

    public boolean findAndUpdate(ApplicationOperationConfiguration configuration) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"serviceId").is((Object)configuration.getServiceId()).and("operationName").is((Object)configuration.getOperationName()).and("appId").is((Object)configuration.getAppId()));
        Update update = MongoHelper.getMongoTemplateUpdates(configuration, "operationType", "status");
        configuration.getOperationTypes().forEach(type -> update.addToSet("operationTypes", type));
        MongoHelper.withMongoTemplateBaseUpdate(update);
        this.mongoTemplate.findAndModify(query, (UpdateDefinition)update, new FindAndModifyOptions().upsert(true).returnNew(true), ServiceOperationCollection.class);
        return true;
    }

    public List<ApplicationOperationConfiguration> queryByMultiCondition(Map<String, Object> conditions) {
        if (conditions == null || conditions.isEmpty()) {
            return Collections.emptyList();
        }
        Query filters = new Query();
        int filterCount = 0;
        for (Map.Entry<String, Object> condition : conditions.entrySet()) {
            if (condition == null || condition.getKey() == null) continue;
            filters.addCriteria((CriteriaDefinition)Criteria.where((String)condition.getKey()).is(condition.getValue()));
            ++filterCount;
        }
        if (filterCount == 0) {
            return Collections.emptyList();
        }
        return this.mongoTemplate.find(filters, ServiceOperationCollection.class).stream().map(ServiceOperationMapper.INSTANCE::dtoFromDao).collect(Collectors.toList());
    }

    public ApplicationOperationConfigurationRepositoryImpl(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }
}

