/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.config.repository.impl;

import com.arextest.config.mapper.ServiceMapper;
import com.arextest.config.model.dao.config.ServiceCollection;
import com.arextest.config.model.dto.application.ApplicationServiceConfiguration;
import com.arextest.config.repository.ConfigRepositoryProvider;
import com.arextest.config.repository.impl.ApplicationOperationConfigurationRepositoryImpl;
import com.arextest.config.utils.MongoHelper;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

public class ApplicationServiceConfigurationRepositoryImpl
implements ConfigRepositoryProvider<ApplicationServiceConfiguration> {
    private final MongoTemplate mongoTemplate;
    private final ApplicationOperationConfigurationRepositoryImpl applicationOperationConfigurationRepository;

    @Override
    public List<ApplicationServiceConfiguration> list() {
        throw new UnsupportedOperationException("this method is not implemented");
    }

    @Override
    public List<ApplicationServiceConfiguration> listBy(String appId) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)appId));
        return this.mongoTemplate.find(filter, ServiceCollection.class).stream().map(source -> {
            ApplicationServiceConfiguration dto = ServiceMapper.INSTANCE.dtoFromDao((ServiceCollection)source);
            dto.setOperationList(this.applicationOperationConfigurationRepository.operationBaseInfoList(dto.getId()));
            return dto;
        }).collect(Collectors.toList());
    }

    @Override
    public boolean update(ApplicationServiceConfiguration configuration) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(configuration.getId())));
        Update update = new Update();
        update.set("status", (Object)configuration.getStatus());
        MongoHelper.withMongoTemplateBaseUpdate(update);
        return this.mongoTemplate.updateMulti(filter, (UpdateDefinition)update, ServiceCollection.class).getModifiedCount() > 0L;
    }

    @Override
    public boolean remove(ApplicationServiceConfiguration configuration) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(configuration.getId())));
        return this.mongoTemplate.remove(filter, ServiceCollection.class).getDeletedCount() > 0L;
    }

    @Override
    public boolean insert(ApplicationServiceConfiguration configuration) {
        ServiceCollection serviceCollection = ServiceMapper.INSTANCE.daoFromDto(configuration);
        this.mongoTemplate.insert((Object)serviceCollection);
        if (serviceCollection.getId() != null) {
            configuration.setId(serviceCollection.getId());
        }
        return serviceCollection.getId() != null;
    }

    @Override
    public long count(String appId) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)appId));
        return this.mongoTemplate.count(filter, ServiceCollection.class);
    }

    @Override
    public boolean removeByAppId(String appId) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)appId));
        return this.mongoTemplate.remove(filter, ServiceCollection.class).getDeletedCount() > 0L;
    }

    public ApplicationServiceConfigurationRepositoryImpl(MongoTemplate mongoTemplate, ApplicationOperationConfigurationRepositoryImpl applicationOperationConfigurationRepository) {
        this.mongoTemplate = mongoTemplate;
        this.applicationOperationConfigurationRepository = applicationOperationConfigurationRepository;
    }
}

