/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.config.repository.impl;

import com.arextest.config.mapper.DynamicClassMapper;
import com.arextest.config.model.dao.config.DynamicClassCollection;
import com.arextest.config.model.dto.record.DynamicClassConfiguration;
import com.arextest.config.repository.ConfigRepositoryProvider;
import com.arextest.config.utils.MongoHelper;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

public class DynamicClassConfigurationRepositoryImpl
implements ConfigRepositoryProvider<DynamicClassConfiguration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicClassConfigurationRepositoryImpl.class);
    private final MongoTemplate mongoTemplate;

    @Override
    public List<DynamicClassConfiguration> list() {
        throw new UnsupportedOperationException("this method is not implemented");
    }

    @Override
    public List<DynamicClassConfiguration> listBy(String appId) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)appId));
        return this.mongoTemplate.find(filter, DynamicClassCollection.class).stream().map(DynamicClassMapper.INSTANCE::dtoFromDao).collect(Collectors.toList());
    }

    @Override
    public boolean update(DynamicClassConfiguration configuration) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(configuration.getId())));
        Update update = MongoHelper.getMongoTemplateUpdates(configuration, "fullClassName", "methodName", "parameterTypes", "keyFormula");
        MongoHelper.withMongoTemplateBaseUpdate(update);
        return this.mongoTemplate.findAndModify(filter, (UpdateDefinition)update, new FindAndModifyOptions().upsert(true), DynamicClassCollection.class) != null;
    }

    @Override
    public boolean remove(DynamicClassConfiguration configuration) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(configuration.getId())));
        return this.mongoTemplate.remove(filter, DynamicClassCollection.class).getDeletedCount() > 0L;
    }

    @Override
    public boolean insert(DynamicClassConfiguration configuration) {
        DynamicClassCollection dynamicClassCollection = DynamicClassMapper.INSTANCE.daoFromDto(configuration);
        this.mongoTemplate.insert((Object)dynamicClassCollection);
        if (dynamicClassCollection.getId() != null) {
            configuration.setId(dynamicClassCollection.getId());
        }
        return dynamicClassCollection.getId() != null;
    }

    @Override
    public boolean removeByAppId(String appId) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)appId));
        return this.mongoTemplate.remove(filter, DynamicClassCollection.class).getDeletedCount() > 0L;
    }

    public boolean cover(String appId, List<DynamicClassConfiguration> configuration) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)appId));
        List allAndRemove = this.mongoTemplate.findAllAndRemove(filter, DynamicClassCollection.class);
        try {
            List daos = configuration.stream().map(DynamicClassMapper.INSTANCE::daoFromDto).collect(Collectors.toList());
            this.mongoTemplate.insertAll(daos);
        }
        catch (RuntimeException e) {
            LOGGER.error("cover error, before cover: {}, after cover: {}", (Object)allAndRemove, configuration);
            return false;
        }
        return true;
    }

    public DynamicClassConfigurationRepositoryImpl(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }
}

