/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.config.repository.impl;

import com.arextest.config.mapper.InstancesMapper;
import com.arextest.config.model.dao.config.InstancesCollection;
import com.arextest.config.model.dto.application.InstancesConfiguration;
import com.arextest.config.repository.ConfigRepositoryProvider;
import com.arextest.config.utils.MongoHelper;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

public class InstancesConfigurationRepositoryImpl
implements ConfigRepositoryProvider<InstancesConfiguration> {
    private final MongoTemplate mongoTemplate;

    @Override
    public List<InstancesConfiguration> list() {
        throw new UnsupportedOperationException("this method is not implemented");
    }

    @Override
    public List<InstancesConfiguration> listBy(String appId) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)appId));
        return this.mongoTemplate.find(filter, InstancesCollection.class).stream().map(InstancesMapper.INSTANCE::dtoFromDao).collect(Collectors.toList());
    }

    public List<InstancesConfiguration> listByAppOrdered(String appId) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)appId));
        filter.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"_id"}));
        return this.mongoTemplate.find(filter, InstancesCollection.class).stream().map(InstancesMapper.INSTANCE::dtoFromDao).collect(Collectors.toList());
    }

    @Override
    public boolean update(InstancesConfiguration configuration) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)configuration.getAppId()).and("host").is((Object)configuration.getHost()));
        Update update = MongoHelper.getFullTemplateUpdates(configuration);
        MongoHelper.withMongoTemplateBaseUpdate(update);
        update.set("dataUpdateTime", (Object)new Date());
        return this.mongoTemplate.upsert(filter, (UpdateDefinition)update, InstancesCollection.class).getModifiedCount() > 0L;
    }

    @Override
    public boolean remove(InstancesConfiguration configuration) {
        return this.mongoTemplate.remove((Object)configuration).getDeletedCount() > 0L;
    }

    @Override
    public boolean insert(InstancesConfiguration configuration) {
        configuration.setDataUpdateTime(new Date());
        InstancesCollection instancesCollection = InstancesMapper.INSTANCE.daoFromDto(configuration);
        this.mongoTemplate.insert((Object)instancesCollection);
        if (configuration.getId() != null) {
            configuration.setId(instancesCollection.getId());
        }
        return configuration.getId() != null;
    }

    @Override
    public boolean removeByAppId(String appId) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)appId));
        return this.mongoTemplate.remove(filter, InstancesCollection.class).getDeletedCount() > 0L;
    }

    public boolean removeByAppIdAndHost(String appId, String host) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)appId).and("host").is((Object)host));
        return this.mongoTemplate.remove(filter, InstancesCollection.class).getDeletedCount() > 0L;
    }

    public InstancesConfigurationRepositoryImpl(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }
}

