/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.config.repository.impl;

import com.arextest.config.mapper.RecordServiceConfigMapper;
import com.arextest.config.model.dao.config.RecordServiceConfigCollection;
import com.arextest.config.model.dto.record.ServiceCollectConfiguration;
import com.arextest.config.repository.MultiEnvConfigRepositoryProvider;
import com.arextest.config.utils.MongoHelper;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

public class ServiceCollectConfigurationRepositoryImpl
implements MultiEnvConfigRepositoryProvider<ServiceCollectConfiguration> {
    private final MongoTemplate mongoTemplate;

    @Override
    public List<ServiceCollectConfiguration> list() {
        throw new UnsupportedOperationException("this method is not implemented");
    }

    @Override
    public List<ServiceCollectConfiguration> listBy(String appId) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)appId));
        return this.mongoTemplate.find(filter, RecordServiceConfigCollection.class).stream().map(RecordServiceConfigMapper.INSTANCE::dtoFromDao).collect(Collectors.toList());
    }

    @Override
    public boolean update(ServiceCollectConfiguration configuration) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)configuration.getAppId()));
        Update update = MongoHelper.getMongoTemplateUpdates(configuration, "sampleRate", "allowDayOfWeeks", "allowTimeOfDayFrom", "allowTimeOfDayTo", "excludeServiceOperationSet", "timeMock", "extendField", "serializeSkipInfoList");
        MongoHelper.withMongoTemplateBaseUpdate(update);
        update.set("recordMachineCountLimit", (Object)(configuration.getRecordMachineCountLimit() == null ? 1 : configuration.getRecordMachineCountLimit()));
        return this.mongoTemplate.updateMulti(filter, (UpdateDefinition)update, RecordServiceConfigCollection.class).getModifiedCount() > 0L;
    }

    @Override
    public boolean remove(ServiceCollectConfiguration configuration) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)configuration.getAppId()));
        return this.mongoTemplate.remove(filter, RecordServiceConfigCollection.class).getDeletedCount() > 0L;
    }

    @Override
    public boolean insert(ServiceCollectConfiguration configuration) {
        RecordServiceConfigCollection recordServiceConfigCollection = RecordServiceConfigMapper.INSTANCE.daoFromDto(configuration);
        return ((RecordServiceConfigCollection)this.mongoTemplate.insert((Object)recordServiceConfigCollection)).getId() != null;
    }

    @Override
    public boolean removeByAppId(String appId) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)appId));
        return this.mongoTemplate.remove(filter, RecordServiceConfigCollection.class).getDeletedCount() > 0L;
    }

    @Override
    public boolean updateMultiEnvConfig(ServiceCollectConfiguration configuration) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"appId").is((Object)configuration.getAppId()));
        List configs = Optional.ofNullable(configuration.getMultiEnvConfigs()).orElse(Collections.emptyList()).stream().map(RecordServiceConfigMapper.INSTANCE::daoFromDto).collect(Collectors.toList());
        Update update = new Update();
        update.set("multiEnvConfigs", configs);
        update.set("dataChangeUpdateTime", (Object)System.currentTimeMillis());
        return this.mongoTemplate.updateMulti(filter, (UpdateDefinition)update, RecordServiceConfigCollection.class).getModifiedCount() > 0L;
    }

    public ServiceCollectConfigurationRepositoryImpl(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }
}

