/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.config.repository.impl;

import com.arextest.config.mapper.SystemConfigurationMapper;
import com.arextest.config.model.dao.config.SystemConfigurationCollection;
import com.arextest.config.model.dto.system.SystemConfiguration;
import com.arextest.config.repository.SystemConfigurationRepository;
import com.arextest.config.utils.MongoHelper;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

public class SystemConfigurationRepositoryImpl
implements SystemConfigurationRepository {
    private final MongoTemplate mongoTemplate;

    @Override
    public boolean saveConfig(SystemConfiguration systemConfig) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"key").is((Object)systemConfig.getKey()));
        Update update = MongoHelper.getFullTemplateUpdates(systemConfig);
        MongoHelper.withMongoTemplateBaseUpdate(update);
        return this.mongoTemplate.upsert(filter, (UpdateDefinition)update, SystemConfigurationCollection.class).getModifiedCount() > 0L;
    }

    @Override
    public List<SystemConfiguration> getAllSystemConfigList() {
        return this.mongoTemplate.findAll(SystemConfigurationCollection.class).stream().map(SystemConfigurationMapper.INSTANCE::dtoFromDao).collect(Collectors.toList());
    }

    @Override
    public SystemConfiguration getSystemConfigByKey(String key) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"key").is((Object)key));
        SystemConfigurationCollection collection = (SystemConfigurationCollection)this.mongoTemplate.findOne(filter, SystemConfigurationCollection.class);
        return collection == null ? null : SystemConfigurationMapper.INSTANCE.dtoFromDao(collection);
    }

    @Override
    public boolean deleteConfig(String key) {
        Query filter = new Query((CriteriaDefinition)Criteria.where((String)"key").is((Object)key));
        return this.mongoTemplate.remove(filter, SystemConfigurationCollection.class).getDeletedCount() > 0L;
    }

    public SystemConfigurationRepositoryImpl(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }
}

