/*
 * Decompiled with CFR 0.152.
 */
package com.arextest.config.utils;

import com.mongodb.client.model.Updates;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Update;

public class MongoHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoHelper.class);

    public static Bson getUpdate() {
        return Updates.combine((Bson[])new Bson[]{Updates.set((String)"dataChangeUpdateTime", (Object)System.currentTimeMillis()), Updates.setOnInsert((String)"dataChangeCreateTime", (Object)System.currentTimeMillis())});
    }

    public static void withMongoTemplateBaseUpdate(Update update) {
        update.set("dataChangeUpdateTime", (Object)System.currentTimeMillis());
        update.setOnInsert("dataChangeCreateTime", (Object)System.currentTimeMillis());
    }

    public static Update getFullTemplateUpdates(Object obj) {
        Map<String, Field> allFields = MongoHelper.getAllField(obj);
        return MongoHelper.getMongoTemplateUpdates(obj, allFields.keySet().toArray(new String[0]));
    }

    public static Update getMongoTemplateUpdates(Object obj, String ... fieldNames) {
        Update update = new Update();
        Map<String, Field> allField = MongoHelper.getAllField(obj);
        for (String fieldName : fieldNames) {
            try {
                if (!allField.containsKey(fieldName)) continue;
                Field declaredField = allField.get(fieldName);
                declaredField.setAccessible(true);
                Object targetObj = declaredField.get(obj);
                if (targetObj == null) continue;
                update.set(fieldName, targetObj);
            }
            catch (IllegalAccessException e) {
                LOGGER.error(String.format("Class:[%s]. failed to get field %s", obj.getClass().getName(), fieldName), (Throwable)e);
            }
        }
        return update;
    }

    private static Map<String, Field> getAllField(Object bean) {
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        for (Class<?> clazz = bean.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (field.isSynthetic() || fieldMap.containsKey(field.getName())) continue;
                fieldMap.put(field.getName(), field);
            }
        }
        return fieldMap;
    }
}

