package com.aripd.arifxh.entity;

import java.io.Serializable;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.Version;

@MappedSuperclass
public abstract class AbstractBaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    //@Basic(optional = false)
    //@Column(nullable = false, columnDefinition = "BIGINT UNSIGNED")
    private Long id;

    //@Version
    //private Long version;

    public AbstractBaseEntity() {
    }

    public Long getId() {
        return id;
    }

    //public Long getVersion() {
        //return version;
    //}

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        } else if (!(obj instanceof AbstractBaseEntity)) {
            return false;
        } else if (((AbstractBaseEntity) obj).id == null) {
            return false;
        } else {
            return ((AbstractBaseEntity) obj).id.equals(this.id);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[ id=" + id + " ]";
    }
}
