package com.aripd.arifxh.entity;

import com.aripd.arifxh.rest.DateAdapter;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name = "fxrate")
@XmlAccessorType(XmlAccessType.NONE)
@Entity
public class FxrateEntity extends AbstractBaseEntity {

    @XmlElement(name = "date")
    //@XmlSchemaType(name="date")
    @XmlJavaTypeAdapter(DateAdapter.class)
    @NotNull
    @Column(nullable = false)
    @Temporal(TemporalType.DATE)
    private Date currencyDate;

    @Size(min = 3, max = 3)
    @NotNull
    @Column(nullable = false, length = 3)
    private String currencyCode;

    private BigDecimal unit;

    @Column(precision = 19, scale = 4)
    private BigDecimal forexBuying;

    @Column(precision = 19, scale = 4)
    private BigDecimal forexSelling;

    @Column(precision = 19, scale = 4)
    private BigDecimal banknoteBuying;

    @XmlElement(name = "close")
    @Column(precision = 19, scale = 4)
    private BigDecimal banknoteSelling;

    public FxrateEntity() {
    }

    public Date getCurrencyDate() {
        return currencyDate;
    }

    public void setCurrencyDate(Date currencyDate) {
        this.currencyDate = currencyDate;
    }

    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public BigDecimal getUnit() {
        return unit;
    }

    public void setUnit(BigDecimal unit) {
        this.unit = unit;
    }

    public BigDecimal getForexBuying() {
        return forexBuying;
    }

    public void setForexBuying(BigDecimal forexBuying) {
        this.forexBuying = forexBuying;
    }

    public BigDecimal getForexSelling() {
        return forexSelling;
    }

    public void setForexSelling(BigDecimal forexSelling) {
        this.forexSelling = forexSelling;
    }

    public BigDecimal getBanknoteBuying() {
        return banknoteBuying;
    }

    public void setBanknoteBuying(BigDecimal banknoteBuying) {
        this.banknoteBuying = banknoteBuying;
    }

    public BigDecimal getBanknoteSelling() {
        return banknoteSelling;
    }

    public void setBanknoteSelling(BigDecimal banknoteSelling) {
        this.banknoteSelling = banknoteSelling;
    }

}
