package com.aripd.arifxh.helper;

import com.aripd.arifxh.model.FxrateDataModel;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FxrateReader {

    static Logger logger = Logger.getLogger(FxrateReader.class.getName());

    private static FxrateReader instance = null;

    private FxrateReader() {
    }

    public static FxrateReader getInstance() {
        if (instance == null) {
            instance = new FxrateReader();
        }
        return instance;
    }

    public List<FxrateDataModel> getCurrencies() {
        List<FxrateDataModel> items = new ArrayList<>();
        try {
            //Ilk once DocumentBuilder nesnesini yaratiyoruz
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();

            //Indirecegimiz xml belgesinin URL'si
            //Burada yerel bir adreste kullanabilirsiniz
            URL u = new URL("http://www.tcmb.gov.tr/kurlar/today.xml");
            logger.info("Fetching " + u.toString());

            //Belgeyi URL'den yukleyip, builder yardimiyla parse ediyoruz
            //Butun belge bellege alinmis oldu
            Document doc = builder.parse(u.openStream());

            String sTarih = doc.getDocumentElement().getAttribute("Date");
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
            Date Tarih_Date = sdf.parse(sTarih);

            //Belge icerisindeki Currency etiketli elemanlari aliyoruz
            NodeList nodes = doc.getElementsByTagName("Currency");
            //Bu elemanlari dolasiyoruz
            for (int i = 0; i < nodes.getLength(); i++) {
                //Her bir eleman icin bir Currency nesnesi yaratiyoruz
                FxrateDataModel currency = new FxrateDataModel();
                //Tarih_Date etiketi icerisinde tanimli tarih bilgisi
                currency.setDate(Tarih_Date);

                Element element = (Element) nodes.item(i);
                //Currency etiketi icerisinde tanimli ozellikleri aliyoruz (property)
                currency.setCurrencyCode(element.getAttribute("CurrencyCode"));
                currency.setKod(element.getAttribute("Kod"));
                //Currency etiketinin alt etiketlerini aliyoruz
                currency.setCurrencyName(getElementValue(element, "CurrencyName"));
                currency.setIsim(getElementValue(element, "Isim"));
                currency.setUnit(getBigDecimal(getElementValue(element, "Unit")));

                Map<FxrateDataModel.Type, BigDecimal> rates = new HashMap<>();
                for (FxrateDataModel.Type type : FxrateDataModel.Type.values()) {
                    rates.put(type, getBigDecimal(getElementValue(element, type.getLabel())));
                }
                currency.setRates(rates);

                items.add(currency);
            }
        } catch (ParserConfigurationException | IOException | SAXException | ParseException ex) {
            logger.error(ex.getMessage());
        }
        return items;
    }

    public List<FxrateDataModel> getCurrenciesPrevious(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(Calendar.DATE, -1);
        Date previous = cal.getTime();
        return getCurrenciesByDate(previous);
    }

    public List<FxrateDataModel> getCurrenciesByDate(Date date) {
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMM");
        SimpleDateFormat sdf2 = new SimpleDateFormat("ddMMyyyy");

        List<FxrateDataModel> items = new ArrayList<>();
        try {
            //Ilk once DocumentBuilder nesnesini yaratiyoruz
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();

            //Indirecegimiz xml belgesinin URL'si
            //Burada yerel bir adreste kullanabilirsiniz
            URL u = new URL(String.format("http://www.tcmb.gov.tr/kurlar/%s/%s.xml", sdf1.format(date), sdf2.format(date)));
            logger.info("Fetching " + u.toString());

            //Belgeyi URL'den yukleyip, builder yardimiyla parse ediyoruz
            //Butun belge bellege alinmis oldu
            Document doc = builder.parse(u.openStream());

            String sTarih = doc.getDocumentElement().getAttribute("Date");
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
            Date Tarih_Date = sdf.parse(sTarih);

            //Belge icerisindeki Currency etiketli elemanlari aliyoruz
            NodeList nodes = doc.getElementsByTagName("Currency");
            //Bu elemanlari dolasiyoruz
            for (int i = 0; i < nodes.getLength(); i++) {
                //Her bir eleman icin bir Currency nesnesi yaratiyoruz
                FxrateDataModel currency = new FxrateDataModel();
                //Tarih_Date etiketi icerisinde tanimli tarih bilgisi
                currency.setDate(Tarih_Date);

                Element element = (Element) nodes.item(i);
                //Currency etiketi icerisinde tanimli ozellikleri aliyoruz (property)
                currency.setCurrencyCode(element.getAttribute("CurrencyCode"));
                currency.setKod(element.getAttribute("Kod"));
                //Currency etiketinin alt etiketlerini aliyoruz
                currency.setCurrencyName(getElementValue(element, "CurrencyName"));
                currency.setIsim(getElementValue(element, "Isim"));
                currency.setUnit(getBigDecimal(getElementValue(element, "Unit")));

                Map<FxrateDataModel.Type, BigDecimal> rates = new HashMap<>();
                for (FxrateDataModel.Type type : FxrateDataModel.Type.values()) {
                    rates.put(type, getBigDecimal(getElementValue(element, type.getLabel())));
                }
                currency.setRates(rates);

                items.add(currency);
            }
        } catch (ParserConfigurationException | IOException | SAXException | ParseException ex) {
            logger.error(ex.getMessage());
        }
        return items;
    }

    private String getCharacterDataFromElement(Element e) {
        try {
            Node child = e.getFirstChild();
            if (child instanceof CharacterData) {
                CharacterData cd = (CharacterData) child;
                return cd.getData();
            }
        } catch (Exception ex) {
        }
        return "";
    }

    protected BigDecimal getBigDecimal(String value) {
        if (value != null && !value.equals("") && !value.equals("(*)")) {
            return new BigDecimal(value);
        }
        return null;
    }

    protected String getElementValue(Element parent, String label) {
        return getCharacterDataFromElement((Element) parent
                .getElementsByTagName(label).item(0));
    }

    public static void main(String[] args) {
        List<FxrateDataModel> currencies = getInstance().getCurrencies();
        System.out.println(currencies.get(0).getDate());
        for (FxrateDataModel currency : currencies) {
            System.out.println(currency.getCurrencyCode() + ": " + currency.getRates().get(FxrateDataModel.Type.BanknoteSelling));
        }
    }

}
