package com.aripd.arifxh.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

public class FxrateDataModel implements Serializable {

    public static enum Type {

        ForexBuying("ForexBuying"),
        ForexSelling("ForexSelling"),
        BanknoteBuying("BanknoteBuying"),
        BanknoteSelling("BanknoteSelling"),
        CrossrateUSD("CrossrateUSD"),
        CrossrateOther("CrossrateOther"),
        CrossrateEURO("CrossrateEURO");

        private final String label;

        private Type(String label) {
            this.label = label;
        }

        public String getLabel() {
            return label;
        }
    }

    private Date date;

    private String kod;

    private String currencyCode;

    private String isim;

    private String currencyName;

    private BigDecimal unit;

    private Map<FxrateDataModel.Type, BigDecimal> rates;

    public FxrateDataModel() {
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getKod() {
        return kod;
    }

    public void setKod(String kod) {
        this.kod = kod;
    }

    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public String getIsim() {
        return isim;
    }

    public void setIsim(String isim) {
        this.isim = isim;
    }

    public String getCurrencyName() {
        return currencyName;
    }

    public void setCurrencyName(String currencyName) {
        this.currencyName = currencyName;
    }

    public BigDecimal getUnit() {
        return unit;
    }

    public void setUnit(BigDecimal unit) {
        this.unit = unit;
    }

    public Map<Type, BigDecimal> getRates() {
        return rates;
    }

    public void setRates(Map<Type, BigDecimal> rates) {
        this.rates = rates;
    }

}
