package com.aripd.arifxh.rest;

import com.aripd.arifxh.entity.FxrateEntity;
import com.aripd.arifxh.service.FxrateService;
import java.util.List;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

@Path("/fxrates")
public class FxrateResource {

    static Logger logger = Logger.getLogger(FxrateResource.class.getName());

    @Inject
    private FxrateService fxrateService;

    public FxrateResource() {
        logger.info(String.format("%s is initialization", this.getClass().getSimpleName()));
    }

    /**
     * List fxrate resources. Use this call to get a list of fxrates.
     * <p>
     * <code>GET /api/v1/fxrates/fxrate/</code>
     * </p>
     *
     * @param currencyCode String
     * @return Returns fxrates
     */
    @Path("/fxrate/{currencyCode}")
    @GET
    @Produces(MediaType.APPLICATION_JSON)
    public List<FxrateEntity> listFxrates(@PathParam("currencyCode") String currencyCode) {
        return fxrateService.findByCurrencyCode(currencyCode);
    }

}
