package com.aripd.arifxh.service;

import com.aripd.arifxh.entity.FxrateEntity;
import com.aripd.arifxh.model.FxrateDataModel;
import java.util.Date;
import java.util.List;
import javax.ejb.Local;

@Local
public interface FxrateService extends CrudService<FxrateEntity, Long> {

    public FxrateEntity findOneByDateAndCode(Date date, String currencyCode);

    public List<FxrateEntity> findByCurrencyCode(String currencyCode);

    public List<FxrateEntity> findByDate(Date date);

    public void doSaveData(FxrateDataModel model);

    public void doFetchData(Date date);

    public void doFetchData(Date start, Date end);

    public List<FxrateEntity> findByFormModel(String currencyCode, Date dateStart, Date dateEnd);

    public List<String> findCurrencies();

}
