package com.aripd.arifxh.service;

import com.aripd.arifxh.entity.FxrateEntity;
import com.aripd.arifxh.entity.FxrateEntity_;
import com.aripd.arifxh.helper.FxrateReader;
import com.aripd.arifxh.model.FxrateDataModel;
import com.aripd.arifxh.util.DateIterator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

@Stateless
public class FxrateServiceBean extends CrudServiceBean<FxrateEntity, Long> implements FxrateService {

    @PersistenceContext
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return em;
    }

    public FxrateServiceBean() {
        super(FxrateEntity.class);
    }

    @Override
    public FxrateEntity findOneByDateAndCode(Date date, String currencyCode) {
        CriteriaBuilder cb = getEntityManager().getCriteriaBuilder();
        CriteriaQuery<FxrateEntity> cq = cb.createQuery(FxrateEntity.class);
        Root<FxrateEntity> root = cq.from(FxrateEntity.class);

        Predicate predicate1 = cb.equal(root.get(FxrateEntity_.currencyDate), date);
        Predicate predicate2 = cb.equal(root.get(FxrateEntity_.currencyCode), currencyCode);
        Predicate predicate = cb.and(predicate1, predicate2);
        cq.where(predicate);

        Query q = getEntityManager().createQuery(cq);
        List<FxrateEntity> results = q.getResultList();
        FxrateEntity entity = null;
        if (!results.isEmpty()) {
            entity = results.get(0);
        }
        return entity;
    }

    @Override
    public List<FxrateEntity> findByCurrencyCode(String currencyCode) {
        CriteriaBuilder cb = getEntityManager().getCriteriaBuilder();
        CriteriaQuery<FxrateEntity> cq = cb.createQuery(FxrateEntity.class);
        Root<FxrateEntity> root = cq.from(FxrateEntity.class);

        Predicate predicate = cb.equal(root.get(FxrateEntity_.currencyCode), currencyCode);
        cq.where(predicate);

        Query q = getEntityManager().createQuery(cq);
        return q.getResultList();

    }

    @Override
    public List<FxrateEntity> findByDate(Date date) {
        CriteriaBuilder cb = getEntityManager().getCriteriaBuilder();
        CriteriaQuery<FxrateEntity> cq = cb.createQuery(FxrateEntity.class);
        Root<FxrateEntity> root = cq.from(FxrateEntity.class);

        Predicate predicate = cb.equal(root.get(FxrateEntity_.currencyDate), date);
        cq.where(predicate);

        Query q = getEntityManager().createQuery(cq);
        return q.getResultList();
    }

    @Override
    public void doSaveData(FxrateDataModel model) {
        Date date = model.getDate();
        String code = model.getKod();
        FxrateEntity fxrate = this.findOneByDateAndCode(date, code);
        if (fxrate == null) {
            FxrateEntity f = new FxrateEntity();
            f.setCurrencyDate(date);
            f.setCurrencyCode(code);
            f.setUnit(model.getUnit());
            f.setForexBuying(model.getRates().get(FxrateDataModel.Type.ForexBuying));
            f.setForexSelling(model.getRates().get(FxrateDataModel.Type.ForexSelling));
            f.setBanknoteBuying(model.getRates().get(FxrateDataModel.Type.BanknoteBuying));
            f.setBanknoteSelling(model.getRates().get(FxrateDataModel.Type.BanknoteSelling));
            this.create(f);
        } else {
            /*
             * TODO update or do nothing
             */

        }
    }

    @Override
    public void doFetchData(Date date) {
        List<FxrateDataModel> currencies = FxrateReader.getInstance().getCurrenciesByDate(date);
        for (FxrateDataModel model : currencies) {
            this.doSaveData(model);
        }
    }

    @Override
    public void doFetchData(Date start, Date end) {
        Iterator<Date> i = new DateIterator(start, end);
        while (i.hasNext()) {
            Date date = i.next();
            this.doFetchData(date);
        }
    }

    @Override
    public List<FxrateEntity> findByFormModel(String currencyCode, Date dateStart, Date dateEnd) {
        CriteriaBuilder cb = getEntityManager().getCriteriaBuilder();
        CriteriaQuery<FxrateEntity> cq = cb.createQuery(FxrateEntity.class);
        Root<FxrateEntity> root = cq.from(FxrateEntity.class);

        Predicate predicate1 = cb.equal(root.get(FxrateEntity_.currencyCode), currencyCode);
        Predicate predicate2 = cb.between(root.get(FxrateEntity_.currencyDate), dateStart, dateEnd);
        Predicate predicate = cb.and(predicate1, predicate2);
        cq.where(predicate);

        Query q = getEntityManager().createQuery(cq);
        return q.getResultList();
    }

    @Override
    public List<String> findCurrencies() {
        CriteriaBuilder cb = getEntityManager().getCriteriaBuilder();
        CriteriaQuery<String> cq = cb.createQuery(String.class);
        Root<FxrateEntity> root = cq.from(FxrateEntity.class);

        cq.select(root.get(FxrateEntity_.currencyCode)).distinct(true);

        Query query = getEntityManager().createQuery(cq);
        return query.getResultList();
    }

}
