package com.aripd.arifxh.view;

import com.aripd.arifxh.helper.FxrateReader;
import com.aripd.arifxh.model.FxrateDataModel;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.view.ViewScoped;
import javax.inject.Named;

@Named
@ViewScoped
public class FxrateBean implements Serializable {

    private List<FxrateDataModel> current;
    private Date date;
    private List<FxrateDataModel> previous;

    @PostConstruct
    public void init() {
        current = FxrateReader.getInstance().getCurrencies();
        date = current.get(0).getDate();
        previous = FxrateReader.getInstance().getCurrenciesPrevious(date);
    }

    public BigDecimal cur(String code) {
        for (FxrateDataModel m : current) {
            if (m.getCurrencyCode().equals(code)) {
                return m.getRates().get(FxrateDataModel.Type.BanknoteSelling);
            }
        }
        return null;
    }

    public BigDecimal pre(String code) {
        for (FxrateDataModel m : previous) {
            if (m.getCurrencyCode().equals(code)) {
                return m.getRates().get(FxrateDataModel.Type.BanknoteSelling);
            }
        }
        return null;
    }

    public BigDecimal change(String code) {
        BigDecimal cur = cur(code);
        BigDecimal pre = pre(code);
        return cur.subtract(pre).divide(pre, RoundingMode.HALF_UP);
    }

    public List<FxrateDataModel> getCurrent() {
        return current;
    }

    public Date getDate() {
        return date;
    }

    public List<FxrateDataModel> getPrevious() {
        return previous;
    }

}
